<?php
// Quick routing test - access via: http://localhost/VV/test_routing.php?path=/VV/products

// Simulate what index.php does
$uri = $_GET['path'] ?? $_SERVER['REQUEST_URI'] ?? '/';
$scriptName = $_SERVER['SCRIPT_NAME'] ?? '';

echo "=== ROUTING DEBUG ===\n\n";
echo "REQUEST_URI: " . ($_SERVER['REQUEST_URI'] ?? 'NOT SET') . "\n";
echo "SCRIPT_NAME: " . $scriptName . "\n";
echo "URI being tested: " . $uri . "\n\n";

// Extract base path from SCRIPT_NAME
$basePath = '';
if ($scriptName && strpos($scriptName, 'index.php') !== false) {
    $basePath = dirname($scriptName);
    $basePath = str_replace('\\', '/', $basePath);
    $basePath = ltrim($basePath, './');
    if ($basePath === '/' || $basePath === '.' || $basePath === '') {
        $basePath = '';
    } else {
        if ($basePath[0] !== '/') {
            $basePath = '/' . $basePath;
        }
    }
}

echo "Detected base path: " . ($basePath ?: 'NONE') . "\n\n";

// Parse URI
$parsedUri = parse_url($uri, PHP_URL_PATH);
$parsedUriDecoded = urldecode($parsedUri);
$basePathDecoded = urldecode($basePath);

echo "Parsed URI: " . $parsedUriDecoded . "\n";
echo "Base path decoded: " . $basePathDecoded . "\n\n";

// Clean URI
$cleanUri = $parsedUriDecoded;
if ($basePathDecoded && $basePathDecoded !== '/') {
    $basePathNormalized = rtrim($basePathDecoded, '/');
    $uriNormalized = $parsedUriDecoded;
    
    if ($uriNormalized === $basePathNormalized || $uriNormalized === $basePathNormalized . '/') {
        $cleanUri = '/';
    } elseif (strpos($uriNormalized, $basePathNormalized . '/') === 0) {
        $cleanUri = substr($uriNormalized, strlen($basePathNormalized));
        if ($cleanUri === '' || $cleanUri[0] !== '/') {
            $cleanUri = '/' . $cleanUri;
        }
    } elseif (strpos($uriNormalized, $basePathNormalized) === 0 && strlen($uriNormalized) > strlen($basePathNormalized)) {
        $cleanUri = substr($uriNormalized, strlen($basePathNormalized));
        if ($cleanUri === '' || $cleanUri[0] !== '/') {
            $cleanUri = '/' . $cleanUri;
        }
    }
}

echo "Clean URI (what Laravel will receive): " . $cleanUri . "\n\n";
echo "=== END DEBUG ===\n";

