

<?php $__env->startSection('title', 'Preview Popup - Admin'); ?>

<?php
    $popupDataArray = [
        'id' => $popup->id,
        'title' => $popup->title,
        'content' => $popup->content,
        'type' => $popup->type,
        'position' => $popup->position,
        'show_close_button' => $popup->show_close_button,
        'close_on_backdrop' => $popup->close_on_backdrop,
        'background_color' => $popup->background_color ?? '#ffffff',
        'text_color' => $popup->text_color ?? '#000000',
        'button_text' => $popup->button_text,
        'button_link' => $popup->button_link,
        'button_color' => $popup->button_color ?? '#ff5349',
        'image' => $popup->image ? productImageUrl($popup->image) : null,
        'width' => $popup->width,
        'height' => $popup->height,
        'desktop_width' => $popup->desktop_width,
        'desktop_height' => $popup->desktop_height,
        'mobile_width' => $popup->mobile_width,
        'mobile_height' => $popup->mobile_height,
        'animation' => $popup->animation ?? 'fade',
    ];
?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-8 flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-gray-900">Preview Popup</h1>
            <p class="text-gray-600 mt-1"><?php echo e($popup->title); ?></p>
        </div>
        <div class="flex items-center space-x-4">
            <a href="<?php echo e(route('admin.popups.edit', $popup)); ?>" class="flex items-center text-gray-600 hover:text-primary transition">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                </svg>
                Edit Popup
            </a>
            <a href="<?php echo e(route('admin.popups.index')); ?>" class="flex items-center text-gray-600 hover:text-primary transition">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                </svg>
                Back to Popups
            </a>
        </div>
    </div>

    <!-- Preview Controls -->
    <div class="bg-white shadow-lg rounded-xl p-6 mb-6">
        <div class="flex items-center justify-between flex-wrap gap-4">
            <div class="flex items-center space-x-4">
                <button onclick="showDesktopPreview()" id="desktop-btn" class="px-4 py-2 bg-primary text-white rounded-lg hover:bg-primary-dark transition font-medium">
                    <svg class="w-5 h-5 inline-block mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                    </svg>
                    Desktop Preview
                </button>
                <button onclick="showMobilePreview()" id="mobile-btn" class="px-4 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300 transition font-medium">
                    <svg class="w-5 h-5 inline-block mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z"/>
                    </svg>
                    Mobile Preview
                </button>
                <button onclick="showBothPreview()" id="both-btn" class="px-4 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300 transition font-medium">
                    <svg class="w-5 h-5 inline-block mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17V7m0 10a2 2 0 01-2 2H5a2 2 0 01-2-2V7a2 2 0 012-2h2a2 2 0 012 2m0 10a2 2 0 002 2h2a2 2 0 002-2M9 7a2 2 0 012-2h2a2 2 0 012 2m0 10V7m0 10a2 2 0 002 2h2a2 2 0 002-2V7a2 2 0 00-2-2h-2a2 2 0 00-2 2"/>
                    </svg>
                    Both Views
                </button>
            </div>
            <button onclick="triggerPopup()" class="px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 transition font-medium">
                <svg class="w-5 h-5 inline-block mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14.752 11.168l-3.197-2.132A1 1 0 0010 9.87v4.263a1 1 0 001.555.832l3.197-2.132a1 1 0 000-1.664z"/>
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                Show Popup
            </button>
        </div>
    </div>

    <!-- Preview Containers -->
    <div id="preview-container" class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Desktop Preview -->
        <div id="desktop-preview" class="preview-panel">
            <div class="bg-white shadow-lg rounded-xl overflow-hidden">
                <div class="bg-gray-800 px-4 py-2 flex items-center justify-between">
                    <div class="flex items-center space-x-2">
                        <div class="w-3 h-3 rounded-full bg-red-500"></div>
                        <div class="w-3 h-3 rounded-full bg-yellow-500"></div>
                        <div class="w-3 h-3 rounded-full bg-green-500"></div>
                    </div>
                    <span class="text-white text-sm font-medium">Desktop Preview (1920x1080)</span>
                    <div class="w-20"></div>
                </div>
                <div class="preview-screen desktop-screen" style="height: 600px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); position: relative; overflow: hidden;">
                    <div id="desktop-popup-container" class="popup-preview-container"></div>
                </div>
            </div>
        </div>

        <!-- Mobile Preview -->
        <div id="mobile-preview" class="preview-panel">
            <div class="bg-white shadow-lg rounded-xl overflow-hidden">
                <div class="bg-gray-800 px-4 py-2 flex items-center justify-center">
                    <span class="text-white text-sm font-medium">Mobile Preview (375x667)</span>
                </div>
                <div class="preview-screen mobile-screen" style="width: 375px; height: 667px; margin: 0 auto; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); position: relative; overflow: hidden; border: 8px solid #1f2937; border-radius: 20px;">
                    <div id="mobile-popup-container" class="popup-preview-container"></div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.preview-panel {
    display: block;
}

.preview-panel.hidden {
    display: none;
}

.preview-screen {
    position: relative;
}

.popup-preview-container {
    width: 100%;
    height: 100%;
    position: relative;
}

.popup-preview {
    position: absolute;
    z-index: 9999;
    opacity: 1;
    visibility: visible;
}

.popup-preview-backdrop {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.5);
    z-index: -1;
}

.popup-preview-content {
    position: relative;
    background: white;
    border-radius: 8px;
    padding: 2rem;
    max-width: 90%;
    max-height: 90vh;
    overflow-y: auto;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
}

.popup-preview-close {
    position: absolute;
    top: 1rem;
    right: 1rem;
    background: transparent;
    border: none;
    font-size: 2rem;
    line-height: 1;
    cursor: pointer;
    color: #666;
    z-index: 10;
    padding: 0.5rem;
    width: 2.5rem;
    height: 2.5rem;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    transition: background 0.2s;
}

.popup-preview-close:hover {
    background: rgba(0, 0, 0, 0.1);
}

.popup-preview-image {
    width: 100%;
    max-height: 300px;
    object-fit: cover;
    border-radius: 4px;
    margin-bottom: 1rem;
}

.popup-preview-title {
    font-size: 1.5rem;
    font-weight: bold;
    margin-bottom: 1rem;
}

.popup-preview-body {
    margin-bottom: 1.5rem;
    line-height: 1.6;
}

.popup-preview-button {
    display: inline-block;
    padding: 0.75rem 1.5rem;
    border-radius: 4px;
    text-decoration: none;
    font-weight: bold;
    transition: opacity 0.2s;
    color: white;
}

.popup-preview-button:hover {
    opacity: 0.9;
}

/* Position classes */
.popup-preview-center {
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
}

.popup-preview-top {
    top: 2rem;
    left: 50%;
    transform: translateX(-50%);
}

.popup-preview-bottom {
    bottom: 2rem;
    left: 50%;
    transform: translateX(-50%);
}

.popup-preview-top-left {
    top: 2rem;
    left: 2rem;
}

.popup-preview-top-right {
    top: 2rem;
    right: 2rem;
}

.popup-preview-bottom-left {
    bottom: 2rem;
    left: 2rem;
}

.popup-preview-bottom-right {
    bottom: 2rem;
    right: 2rem;
}

/* Mobile specific adjustments */
.mobile-screen .popup-preview-content {
    padding: 1.5rem;
    max-width: 95%;
}

.mobile-screen .popup-preview-title {
    font-size: 1.25rem;
}

.mobile-screen .popup-preview-image {
    max-height: 200px;
}
</style>

<script>
const popupData = <?php echo json_encode($popupDataArray, 15, 512) ?>;

let currentView = 'both';

function showDesktopPreview() {
    currentView = 'desktop';
    document.getElementById('desktop-preview').classList.remove('hidden');
    document.getElementById('mobile-preview').classList.add('hidden');
    document.getElementById('preview-container').classList.remove('lg:grid-cols-2');
    document.getElementById('preview-container').classList.add('lg:grid-cols-1');
    
    document.getElementById('desktop-btn').classList.add('bg-primary', 'text-white');
    document.getElementById('desktop-btn').classList.remove('bg-gray-200', 'text-gray-700');
    document.getElementById('mobile-btn').classList.remove('bg-primary', 'text-white');
    document.getElementById('mobile-btn').classList.add('bg-gray-200', 'text-gray-700');
    document.getElementById('both-btn').classList.remove('bg-primary', 'text-white');
    document.getElementById('both-btn').classList.add('bg-gray-200', 'text-gray-700');
}

function showMobilePreview() {
    currentView = 'mobile';
    document.getElementById('desktop-preview').classList.add('hidden');
    document.getElementById('mobile-preview').classList.remove('hidden');
    document.getElementById('preview-container').classList.remove('lg:grid-cols-2');
    document.getElementById('preview-container').classList.add('lg:grid-cols-1');
    
    document.getElementById('mobile-btn').classList.add('bg-primary', 'text-white');
    document.getElementById('mobile-btn').classList.remove('bg-gray-200', 'text-gray-700');
    document.getElementById('desktop-btn').classList.remove('bg-primary', 'text-white');
    document.getElementById('desktop-btn').classList.add('bg-gray-200', 'text-gray-700');
    document.getElementById('both-btn').classList.remove('bg-primary', 'text-white');
    document.getElementById('both-btn').classList.add('bg-gray-200', 'text-gray-700');
}

function showBothPreview() {
    currentView = 'both';
    document.getElementById('desktop-preview').classList.remove('hidden');
    document.getElementById('mobile-preview').classList.remove('hidden');
    document.getElementById('preview-container').classList.remove('lg:grid-cols-1');
    document.getElementById('preview-container').classList.add('lg:grid-cols-2');
    
    document.getElementById('both-btn').classList.add('bg-primary', 'text-white');
    document.getElementById('both-btn').classList.remove('bg-gray-200', 'text-gray-700');
    document.getElementById('desktop-btn').classList.remove('bg-primary', 'text-white');
    document.getElementById('desktop-btn').classList.add('bg-gray-200', 'text-gray-700');
    document.getElementById('mobile-btn').classList.remove('bg-primary', 'text-white');
    document.getElementById('mobile-btn').classList.add('bg-gray-200', 'text-gray-700');
}

function createPopupElement(container, isMobile = false) {
    // Clear container
    container.innerHTML = '';
    
    const popupDiv = document.createElement('div');
    popupDiv.className = `popup-preview popup-preview-${popupData.type} popup-preview-${popupData.position} popup-preview-animation-${popupData.animation}`;
    
    const styles = {
        backgroundColor: popupData.background_color,
        color: popupData.text_color,
    };
    
    // Use mobile or desktop sizes based on preview type
    if (isMobile) {
        if (popupData.mobile_width) {
            styles.width = popupData.mobile_width.toString().includes('%') ? popupData.mobile_width : `${popupData.mobile_width}px`;
        } else if (popupData.width) {
            styles.width = typeof popupData.width === 'number' ? `${popupData.width}px` : popupData.width;
        }
        if (popupData.mobile_height) {
            styles.height = `${popupData.mobile_height}px`;
        } else if (popupData.height) {
            styles.height = `${popupData.height}px`;
        }
    } else {
        if (popupData.desktop_width) {
            styles.width = `${popupData.desktop_width}px`;
        } else if (popupData.width) {
            styles.width = typeof popupData.width === 'number' ? `${popupData.width}px` : popupData.width;
        }
        if (popupData.desktop_height) {
            styles.height = `${popupData.desktop_height}px`;
        } else if (popupData.height) {
            styles.height = `${popupData.height}px`;
        }
    }
    
    Object.assign(popupDiv.style, styles);
    
    // Backdrop
    const backdrop = document.createElement('div');
    backdrop.className = 'popup-preview-backdrop';
    backdrop.addEventListener('click', () => {
        if (popupData.close_on_backdrop) {
            container.innerHTML = '';
        }
    });
    
    // Content wrapper
    const content = document.createElement('div');
    content.className = 'popup-preview-content';
    
    // Close button
    if (popupData.show_close_button) {
        const closeBtn = document.createElement('button');
        closeBtn.className = 'popup-preview-close';
        closeBtn.innerHTML = '&times;';
        closeBtn.setAttribute('aria-label', 'Close');
        closeBtn.addEventListener('click', () => {
            container.innerHTML = '';
        });
        content.appendChild(closeBtn);
    }
    
    // Image
    if (popupData.image) {
        const img = document.createElement('img');
        img.src = popupData.image;
        img.alt = popupData.title;
        img.className = 'popup-preview-image';
        content.appendChild(img);
    }
    
    // Title
    if (popupData.title) {
        const title = document.createElement('h3');
        title.className = 'popup-preview-title';
        title.textContent = popupData.title;
        content.appendChild(title);
    }
    
    // Content
    if (popupData.content) {
        const contentDiv = document.createElement('div');
        contentDiv.className = 'popup-preview-body';
        contentDiv.innerHTML = popupData.content;
        content.appendChild(contentDiv);
    }
    
    // Button
    if (popupData.button_text && popupData.button_link) {
        const button = document.createElement('a');
        button.href = popupData.button_link;
        button.className = 'popup-preview-button';
        button.textContent = popupData.button_text;
        button.style.backgroundColor = popupData.button_color;
        button.style.color = '#ffffff';
        content.appendChild(button);
    }
    
    popupDiv.appendChild(backdrop);
    popupDiv.appendChild(content);
    
    container.appendChild(popupDiv);
    
    // Trigger animation
    setTimeout(() => {
        popupDiv.classList.add('popup-preview-show');
    }, 10);
}

function triggerPopup() {
    const desktopContainer = document.getElementById('desktop-popup-container');
    const mobileContainer = document.getElementById('mobile-popup-container');
    
    if (currentView === 'desktop' || currentView === 'both') {
        createPopupElement(desktopContainer, false);
    }
    
    if (currentView === 'mobile' || currentView === 'both') {
        createPopupElement(mobileContainer, true);
    }
}

// Initialize with both views
showBothPreview();
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\TrendzTrade\resources\views/admin/popups/preview.blade.php ENDPATH**/ ?>