<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Confirmation</title>
</head>
<body style="margin: 0; padding: 0; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif; background-color: #f5f5f5;">
    <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f5f5f5; padding: 40px 0;">
        <tr>
            <td align="center">
                <table width="600" cellpadding="0" cellspacing="0" style="background-color: #ffffff; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); overflow: hidden;">
                    <!-- Header -->
                    <tr>
                        <td style="background: linear-gradient(135deg, <?php echo e($primaryColor ?? '#ff5349'); ?> 0%, <?php echo e($primaryColor ?? '#ff5349'); ?>dd 100%); padding: 40px 30px; text-align: center;">
                            <h1 style="margin: 0; color: #ffffff; font-size: 28px; font-weight: 700;"><?php echo e($siteTitle); ?></h1>
                            <p style="margin: 10px 0 0 0; color: #ffffff; font-size: 16px; opacity: 0.9;">Order Confirmation</p>
                        </td>
                    </tr>
                    
                    <!-- Success Message -->
                    <tr>
                        <td style="padding: 30px; text-align: center; background-color: #f0fdf4;">
                            <div style="display: inline-block; width: 60px; height: 60px; background-color: #10b981; border-radius: 50%; line-height: 60px; margin-bottom: 15px;">
                                <span style="color: #ffffff; font-size: 30px;">✓</span>
                            </div>
                            <h2 style="margin: 0 0 10px 0; color: #065f46; font-size: 24px; font-weight: 700;">Thank You for Your Order!</h2>
                            <p style="margin: 0; color: #047857; font-size: 16px;">Your order has been received and is being processed.</p>
                        </td>
                    </tr>
                    
                    <!-- Order Details -->
                    <tr>
                        <td style="padding: 30px;">
                            <div style="background-color: #f9fafb; border-radius: 8px; padding: 20px; margin-bottom: 20px;">
                                <h3 style="margin: 0 0 15px 0; color: #111827; font-size: 18px; font-weight: 700;">Order Information</h3>
                                <table width="100%" cellpadding="0" cellspacing="0">
                                    <tr>
                                        <td style="padding: 8px 0; color: #6b7280; font-size: 14px;">Order Number:</td>
                                        <td style="padding: 8px 0; color: #111827; font-size: 14px; font-weight: 600; text-align: right;"><?php echo e($order->order_number); ?></td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 8px 0; color: #6b7280; font-size: 14px;">Order Date:</td>
                                        <td style="padding: 8px 0; color: #111827; font-size: 14px; text-align: right;"><?php echo e($order->created_at->format('M d, Y h:i A')); ?></td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 8px 0; color: #6b7280; font-size: 14px;">Status:</td>
                                        <td style="padding: 8px 0; color: #111827; font-size: 14px; text-align: right; text-transform: capitalize;"><?php echo e($order->status); ?></td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 8px 0; color: #6b7280; font-size: 14px;">Payment Method:</td>
                                        <td style="padding: 8px 0; color: #111827; font-size: 14px; text-align: right; text-transform: capitalize;"><?php echo e(str_replace('_', ' ', $order->payment_method)); ?></td>
                                    </tr>
                                </table>
                            </div>

                            <!-- Order Items -->
                            <h3 style="margin: 0 0 15px 0; color: #111827; font-size: 18px; font-weight: 700;">Order Items</h3>
                            <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div style="display: flex; gap: 15px; padding: 15px 0; border-bottom: 1px solid #e5e7eb;">
                                    <div style="width: 80px; height: 80px; background-color: #f3f4f6; border-radius: 8px; overflow: hidden; flex-shrink: 0;">
                                        <?php
                                            // For emails, we need absolute URLs - ensure we get full URL
                                            $imagePath = $item->product_image ?? '';
                                            if (empty($imagePath)) {
                                                $imageUrl = url('images/placeholder.jpg');
                                            } elseif (substr($imagePath, 0, 4) === 'http') {
                                                $imageUrl = $imagePath;
                                            } else {
                                                // Handle old format: /public/storage/products/image.jpg
                                                if (strpos($imagePath, '/public/storage/') === 0) {
                                                    $imagePath = str_replace('/public/storage/', 'storage/', $imagePath);
                                                }
                                                // Handle old format: public/storage/products/image.jpg
                                                elseif (strpos($imagePath, 'public/storage/') === 0) {
                                                    $imagePath = str_replace('public/storage/', 'storage/', $imagePath);
                                                }
                                                // Handle new format: products/image.jpg (relative path from storage/app/public)
                                                elseif (strpos($imagePath, 'storage/') !== 0 && strpos($imagePath, '/') !== 0) {
                                                    $imagePath = 'storage/' . ltrim($imagePath, '/');
                                                }
                                                // Handle /storage/products/image.jpg
                                                elseif (strpos($imagePath, '/storage/') === 0) {
                                                    $imagePath = ltrim($imagePath, '/');
                                                }
                                                // Generate absolute URL using APP_URL
                                                $baseUrl = rtrim(config('app.url'), '/');
                                                $imageUrl = $baseUrl . '/' . ltrim($imagePath, '/');
                                            }
                                        ?>
                                        <img src="<?php echo e($imageUrl); ?>" alt="<?php echo e($item->product_name); ?>" style="width: 100%; height: 100%; object-fit: cover;" onerror="this.style.display='none'; this.parentElement.innerHTML='<div style=\'width:100%;height:100%;display:flex;align-items:center;justify-content:center;background-color:#f3f4f6;color:#9ca3af;font-size:10px;\'>No Image</div>';">
                                    </div>
                                    <div style="flex: 1;">
                                        <h4 style="margin: 0 0 5px 0; color: #111827; font-size: 16px; font-weight: 600;"><?php echo e($item->product_name); ?></h4>
                                        <?php if($item->size): ?>
                                            <p style="margin: 0 0 3px 0; color: #6b7280; font-size: 13px;">Size: <?php echo e($item->size); ?></p>
                                        <?php endif; ?>
                                        <?php if($item->color): ?>
                                            <p style="margin: 0 0 3px 0; color: #6b7280; font-size: 13px;">Color: <?php echo e($item->color); ?></p>
                                        <?php endif; ?>
                                        <p style="margin: 0 0 3px 0; color: #6b7280; font-size: 13px;">Quantity: <?php echo e($item->quantity); ?></p>
                                        <p style="margin: 5px 0 0 0; color: #111827; font-size: 16px; font-weight: 600;"><?php echo e(currency($item->subtotal)); ?></p>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <!-- Order Summary -->
                            <div style="background-color: #f9fafb; border-radius: 8px; padding: 20px; margin-top: 20px;">
                                <h3 style="margin: 0 0 15px 0; color: #111827; font-size: 18px; font-weight: 700;">Order Summary</h3>
                                <table width="100%" cellpadding="0" cellspacing="0">
                                    <tr>
                                        <td style="padding: 8px 0; color: #6b7280; font-size: 14px;">Subtotal:</td>
                                        <td style="padding: 8px 0; color: #111827; font-size: 14px; text-align: right;"><?php echo e(currency($order->subtotal)); ?></td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 8px 0; color: #6b7280; font-size: 14px;">Tax:</td>
                                        <td style="padding: 8px 0; color: #111827; font-size: 14px; text-align: right;"><?php echo e(currency($order->tax)); ?></td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 8px 0; color: #6b7280; font-size: 14px;">Shipping:</td>
                                        <td style="padding: 8px 0; color: #111827; font-size: 14px; text-align: right;"><?php echo e(currency($order->shipping)); ?></td>
                                    </tr>
                                    <tr style="border-top: 2px solid #e5e7eb;">
                                        <td style="padding: 12px 0 0 0; color: #111827; font-size: 18px; font-weight: 700;">Total:</td>
                                        <td style="padding: 12px 0 0 0; color: #111827; font-size: 18px; font-weight: 700; text-align: right;"><?php echo e(currency($order->total)); ?></td>
                                    </tr>
                                </table>
                            </div>

                            <!-- Shipping Address -->
                            <div style="margin-top: 20px;">
                                <h3 style="margin: 0 0 15px 0; color: #111827; font-size: 18px; font-weight: 700;">Shipping Address</h3>
                                <div style="color: #6b7280; font-size: 14px; line-height: 1.8;">
                                    <p style="margin: 0;"><?php echo e($order->shipping_name); ?></p>
                                    <p style="margin: 0;"><?php echo e($order->shipping_address); ?></p>
                                    <?php if($order->shipping_city || $order->shipping_state || $order->shipping_postal_code): ?>
                                        <p style="margin: 0;"><?php echo e($order->shipping_city); ?><?php echo e($order->shipping_state ? ', ' . $order->shipping_state : ''); ?> <?php echo e($order->shipping_postal_code); ?></p>
                                    <?php endif; ?>
                                    <?php if($order->shipping_country): ?>
                                        <p style="margin: 0;"><?php echo e($order->shipping_country); ?></p>
                                    <?php endif; ?>
                                    <p style="margin: 5px 0 0 0;"><?php echo e($order->shipping_email); ?></p>
                                    <p style="margin: 0;"><?php echo e($order->shipping_phone); ?></p>
                                </div>
                            </div>
                        </td>
                    </tr>
                    
                    <!-- Footer -->
                    <tr>
                        <td style="background-color: #f9fafb; padding: 30px; text-align: center; border-top: 1px solid #eeeeee;">
                            <p style="margin: 0; color: #9ca3af; font-size: 12px;">
                                &copy; <?php echo e(date('Y')); ?> <?php echo e($siteTitle); ?>. All rights reserved.
                            </p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>

<?php /**PATH C:\wamp64\www\TrendzTrade\resources\views/emails/order-confirmation.blade.php ENDPATH**/ ?>