

<?php $__env->startSection('title', $title ?? 'Store Portal'); ?>

<?php $__env->startSection('content'); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'Store Portal'); ?> - <?php echo e(config('app.name')); ?></title>
    <link href="https://fonts.bunny.net/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --bg-sidebar: #ffffff;
            --bg-main: #f8fafc;
            --text-main: #1e293b;
            --text-muted: #94a3b8;
            --primary: #5b5cf5;
            --border-color: #f1f5f9;
        }

        * { box-sizing: border-box; margin: 0; padding: 0; outline: none; }

        body {
            font-family: 'Plus Jakarta Sans', sans-serif;
            background-color: var(--bg-main);
            color: var(--text-main);
            min-height: 100vh;
            overflow-x: hidden;
        }

        /* Mobile Header */
        .mobile-header {
            display: none;
            padding: 1rem 1.5rem;
            background: white;
            border-bottom: 1px solid var(--border-color);
            align-items: center;
            justify-content: space-between;
            position: sticky;
            top: 0;
            z-index: 100;
        }

        /* Full Screen Wrapper */
        .app-container {
            display: flex;
            width: 100%;
            min-height: 100vh;
        }

        /* --- SIDEBAR --- */
        .sidebar {
            width: 180px;
            background: var(--bg-sidebar);
            border-right: 1px solid var(--border-color);
            display: flex;
            flex-direction: column;
            padding: 2rem 0.75rem;
            flex-shrink: 0;
            transition: transform 0.3s ease;
        }

        .logo-area {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 3rem;
            padding-left: 0.5rem;
        }

        .logo-icon-box {
            width: 38px;
            height: 38px;
            background: #000;
            color: white;
            border-radius: 10px;
            display: grid;
            place-items: center;
            font-weight: 800;
            font-size: 1rem;
        }

        .logo-text-box {
            font-size: 0.65rem;
            font-weight: 800;
            line-height: 1.2;
            color: #000;
            letter-spacing: 0.5px;
        }

        .nav-menu {
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
            flex: 1;
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 10px 14px;
            color: var(--text-muted);
            text-decoration: none;
            font-weight: 700;
            font-size: 0.8rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            border-radius: 12px;
            transition: all 0.2s;
        }

        .nav-link:hover, .nav-link.active {
            color: var(--text-main);
            background: #f8fafc;
        }

        .nav-link i {
            font-size: 1rem;
            width: 20px;
            text-align: center;
        }

        .profile-section {
            margin-top: auto;
            background: #f8fafc;
            border-radius: 16px;
            padding: 0.75rem;
            display: flex;
            align-items: center;
            gap: 12px;
            border: 1px solid var(--border-color);
        }

        .profile-circle {
            width: 36px;
            height: 36px;
            background: var(--primary);
            border-radius: 10px;
            display: grid;
            place-items: center;
            font-weight: 800;
            font-size: 0.85rem;
            color: white;
            flex-shrink: 0;
        }

        .profile-info {
            flex: 1;
            min-width: 0;
        }

        .profile-name { 
            font-weight: 800; 
            font-size: 0.8rem; 
            color: var(--text-main);
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .profile-btn { 
            color: #ef4444; 
            font-size: 0.65rem; 
            font-weight: 800; 
            text-decoration: none;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            opacity: 0.8;
            transition: opacity 0.2s;
        }
        .profile-btn:hover { opacity: 1; }

        /* --- MAIN CONTENT --- */
        .content-area {
            flex: 1;
            overflow-y: auto;
            display: flex;
            background: #ffffff;
        }

        .main-wrapper {
            flex: 1;
            padding: 2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
        }

        .summary-wrapper {
            width: 320px;
            border-left: 1px solid var(--border-color);
            padding: 2.5rem 2rem;
            display: flex;
            flex-direction: column;
            gap: 2.5rem;
            flex-shrink: 0;
        }

        /* Flash Messages */
        .flash {
            padding: 1rem 1.5rem;
            border-radius: 16px;
            margin-bottom: 1rem;
            font-weight: 700;
            font-size: 0.9rem;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        .flash.success { background: #f0fdf4; color: #166534; border: 1px solid #dcfce7; }
        .flash.error { background: #fef2f2; color: #991b1b; border: 1px solid #fee2e2; }
        .flash.info { background: #eff6ff; color: #1e40af; border: 1px solid #dbeafe; }

        /* Responsive */
        @media (max-width: 1200px) {
            .app-container { flex-direction: column; min-height: auto; }
            .content-area { flex-direction: column; overflow: visible; }
            .summary-wrapper { 
                width: 100%; 
                border-left: none; 
                border-top: 1px solid var(--border-color); 
                padding: 2rem 1.5rem; 
            }
        }

        @media (max-width: 992px) {
            .sidebar {
                position: fixed;
                left: 0;
                top: 0;
                bottom: 0;
                z-index: 1000;
                transform: translateX(-100%);
                width: 240px;
                padding: 2rem 1.5rem;
            }
            .sidebar.active {
                transform: translateX(0);
                box-shadow: 20px 0 50px rgba(0,0,0,0.1);
            }
            .mobile-header {
                display: flex;
            }
            .main-wrapper {
                padding: 1.25rem;
                gap: 1.5rem;
            }
            .sidebar-overlay {
                display: none;
                position: fixed;
                inset: 0;
                background: rgba(0,0,0,0.5);
                backdrop-filter: blur(4px);
                z-index: 999;
            }
            .sidebar-overlay.active {
                display: block;
            }
        }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>

<div class="sidebar-overlay" id="sidebarOverlay" onclick="toggleSidebar()"></div>

<header class="mobile-header">
    <div style="display: flex; align-items: center; gap: 12px;">
        <button onclick="toggleSidebar()" style="background: #f8fafc; border: 1px solid var(--border-color); width: 40px; height: 40px; border-radius: 10px; font-size: 1.1rem; cursor: pointer; color: var(--text-main); display: grid; place-items: center;"><i class="fas fa-bars"></i></button>
        <div style="font-weight: 800; font-size: 0.85rem; color: #000; letter-spacing: 0.5px; line-height: 1.1;">STORE<br>PORTAL</div>
    </div>
    <?php if(auth()->user()): ?>
        <div class="profile-circle" style="width: 36px; height: 36px; margin: 0; font-size: 0.8rem; background: var(--primary); color: white; border-radius: 10px;"><?php echo e(strtoupper(substr(auth()->user()->name, 0, 1))); ?></div>
    <?php endif; ?>
</header>

<div class="app-container">
    <!-- Sidebar -->
    <aside class="sidebar" id="adminSidebar">
        <div class="logo-area">
            <div class="logo-icon-box">
                <?php if(auth()->user()->store && auth()->user()->store->logo): ?>
                    <img src="<?php echo e(asset('storage/' . auth()->user()->store->logo)); ?>" alt="" style="width: 100%; height: 100%; object-fit: cover; border-radius: 10px;">
                <?php else: ?>
                    <i class="fas fa-store"></i>
                <?php endif; ?>
            </div>
            <div class="logo-text-box">
                <?php if(auth()->user()->store): ?>
                    <?php echo e(strtoupper(substr(auth()->user()->store->business_name, 0, 10))); ?><br>PORTAL
                <?php else: ?>
                    STORE<br>PORTAL
                <?php endif; ?>
            </div>
        </div>

        <nav class="nav-menu">
            <a href="<?php echo e(route('store.dashboard')); ?>" class="nav-link <?php echo e(request()->routeIs('store.dashboard') ? 'active' : ''); ?>">
                <i class="fas fa-th-large"></i> Dashboard
            </a>
            <a href="<?php echo e(route('store.products.index')); ?>" class="nav-link <?php echo e(request()->routeIs('store.products.*') ? 'active' : ''); ?>">
                <i class="fas fa-box"></i> Products
            </a>
            <a href="<?php echo e(route('store.orders.index')); ?>" class="nav-link <?php echo e(request()->routeIs('store.orders.*') ? 'active' : ''); ?>">
                <i class="fas fa-exchange-alt"></i> Orders
            </a>
            <a href="<?php echo e(route('store.request-quotes.index')); ?>" class="nav-link <?php echo e(request()->routeIs('store.request-quotes.*') ? 'active' : ''); ?>">
                <i class="fas fa-file-invoice"></i> Quotes
            </a>
            <a href="<?php echo e(route('store.coupons.index')); ?>" class="nav-link <?php echo e(request()->routeIs('store.coupons.*') ? 'active' : ''); ?>">
                <i class="fas fa-ticket-alt"></i> Coupons
            </a>
            <a href="<?php echo e(route('store.reviews.index')); ?>" class="nav-link <?php echo e(request()->routeIs('store.reviews.*') ? 'active' : ''); ?>">
                <i class="fas fa-star"></i> Reviews
            </a>
            <a href="<?php echo e(route('store.returns.index')); ?>" class="nav-link <?php echo e(request()->routeIs('store.returns.*') ? 'active' : ''); ?>">
                <i class="fas fa-undo"></i> Returns
            </a>
            <a href="<?php echo e(route('store.withdraw.index')); ?>" class="nav-link <?php echo e(request()->routeIs('store.withdraw.*') ? 'active' : ''); ?>">
                <i class="fas fa-wallet"></i> Withdraw
            </a>
            <a href="<?php echo e(route('store.staff.index')); ?>" class="nav-link <?php echo e(request()->routeIs('store.staff.*') ? 'active' : ''); ?>">
                <i class="fas fa-users"></i> Staff
            </a>
            <a href="<?php echo e(route('store.followers.index')); ?>" class="nav-link <?php echo e(request()->routeIs('store.followers.*') ? 'active' : ''); ?>">
                <i class="fas fa-user-plus"></i> Followers
            </a>
            <a href="<?php echo e(route('store.announcements.index')); ?>" class="nav-link <?php echo e(request()->routeIs('store.announcements.*') ? 'active' : ''); ?>">
                <i class="fas fa-bullhorn"></i> Announce
            </a>
            <a href="<?php echo e(route('store.analytics.index')); ?>" class="nav-link <?php echo e(request()->routeIs('store.analytics.*') ? 'active' : ''); ?>">
                <i class="fas fa-chart-line"></i> Analytics
            </a>
            <a href="<?php echo e(route('store.reports.index')); ?>" class="nav-link <?php echo e(request()->routeIs('store.reports.*') ? 'active' : ''); ?>">
                <i class="fas fa-chart-bar"></i> Reports
            </a>
            <a href="<?php echo e(route('store.tools.index')); ?>" class="nav-link <?php echo e(request()->routeIs('store.tools.*') ? 'active' : ''); ?>">
                <i class="fas fa-tools"></i> Tools
            </a>
            <a href="<?php echo e(route('home')); ?>" class="nav-link">
                <i class="fas fa-external-link-alt"></i> View Site
            </a>
        </nav>

        <div class="profile-section">
            <div class="profile-circle"><?php echo e(strtoupper(substr(auth()->user()->name, 0, 1))); ?></div>
            <div class="profile-info">
                <div class="profile-name"><?php echo e(auth()->user()->name); ?></div>
                <a href="<?php echo e(route('logout')); ?>" class="profile-btn" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">Logout</a>
                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                    <?php echo csrf_field(); ?>
                </form>
            </div>
        </div>
    </aside>

    <div class="content-area">
        <div class="main-wrapper">
            <!-- Flash Messages -->
            <?php if(session('success')): ?>
                <div class="flash success">
                    <i class="fas fa-check-circle"></i>
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="flash error">
                    <i class="fas fa-exclamation-circle"></i>
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <?php if(session('info')): ?>
                <div class="flash info">
                    <i class="fas fa-info-circle"></i>
                    <?php echo e(session('info')); ?>

                </div>
            <?php endif; ?>

            <?php echo $__env->yieldContent('store-content'); ?>
        </div>

        <?php if (! empty(trim($__env->yieldContent('summary-content')))): ?>
            <div class="summary-wrapper">
                <?php echo $__env->yieldContent('summary-content'); ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
function toggleSidebar() {
    const sidebar = document.getElementById('adminSidebar');
    const overlay = document.getElementById('sidebarOverlay');
    
    sidebar.classList.toggle('active');
    overlay.classList.toggle('active');
    
    if (sidebar.classList.contains('active')) {
        document.body.style.overflow = 'hidden';
    } else {
        document.body.style.overflow = '';
    }
}
</script>

<?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\TrendzTrade\resources\views/store/layout.blade.php ENDPATH**/ ?>