<?php $__env->startSection('title', 'Manage Products - Admin'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-gray-900">Manage Products</h1>
        <a href="<?php echo e(route('admin.products.create')); ?>" class="bg-primary text-white px-6 py-2 rounded hover:bg-primary-dark transition">
            Create New Product
        </a>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6 rounded" role="alert">
            <p><?php echo e(session('success')); ?></p>
        </div>
    <?php endif; ?>

    <!-- Tabs -->
    <div class="bg-white shadow rounded-lg mb-6">
        <div class="border-b border-gray-200">
            <nav class="-mb-px flex space-x-8 px-6" aria-label="Tabs">
                <a href="<?php echo e(route('admin.products.index', ['status' => 'pending'])); ?>" 
                   class="<?php echo e((request('status') == 'pending' || !request('status')) ? 'border-primary text-primary' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'); ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                    Pending
                    <span class="ml-2 bg-gray-100 text-gray-600 py-0.5 px-2.5 rounded-full text-xs font-medium">
                        <?php echo e($pendingCount); ?>

                    </span>
                </a>
                <a href="<?php echo e(route('admin.products.index', ['status' => 'approved'])); ?>" 
                   class="<?php echo e(request('status') == 'approved' ? 'border-primary text-primary' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'); ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                    Approved
                    <span class="ml-2 bg-green-100 text-green-600 py-0.5 px-2.5 rounded-full text-xs font-medium">
                        <?php echo e($approvedCount); ?>

                    </span>
                </a>
                <a href="<?php echo e(route('admin.products.index', ['status' => 'rejected'])); ?>" 
                   class="<?php echo e(request('status') == 'rejected' ? 'border-primary text-primary' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'); ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                    Rejected
                    <span class="ml-2 bg-red-100 text-red-600 py-0.5 px-2.5 rounded-full text-xs font-medium">
                        <?php echo e($rejectedCount); ?>

                    </span>
                </a>
                <a href="<?php echo e(route('admin.products.index')); ?>" 
                   class="<?php echo e(!request('status') && request('status') !== 'pending' ? 'border-primary text-primary' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'); ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                    All Products
                    <span class="ml-2 bg-blue-100 text-blue-600 py-0.5 px-2.5 rounded-full text-xs font-medium">
                        <?php echo e($totalCount); ?>

                    </span>
                </a>
            </nav>
        </div>
    </div>

    <?php if($products->count() > 0): ?>
        <!-- Bulk Actions Bar -->
        <div id="bulkActionsBar" class="hidden bg-white shadow rounded-lg mb-4 p-4 border-l-4 border-primary">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-4">
                    <span class="text-sm font-medium text-gray-700">
                        <span id="selectedCount">0</span> product(s) selected
                    </span>
                    <div class="flex items-center space-x-2">
                        <select id="bulkActionSelect" class="block w-48 rounded-md border-gray-300 shadow-sm focus:border-primary focus:ring-primary sm:text-sm">
                            <option value="">Select Action</option>
                            <?php if(request('status') == 'pending' || !request('status')): ?>
                                <option value="approve">Approve Selected</option>
                                <option value="reject">Reject Selected</option>
                            <?php endif; ?>
                            <option value="activate">Activate Selected</option>
                            <option value="deactivate">Deactivate Selected</option>
                            <option value="delete">Delete Selected</option>
                        </select>
                        <button type="button" onclick="applyBulkAction()" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-primary hover:bg-primary-dark focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary">
                            Apply
                        </button>
                        <button type="button" onclick="clearSelection()" class="inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary">
                            Clear
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="bg-white shadow overflow-hidden sm:rounded-md">
            <!-- Header with Select All -->
            <div class="px-4 py-3 bg-gray-50 border-b border-gray-200 flex items-center">
                <input type="checkbox" 
                       id="selectAll" 
                       class="h-4 w-4 text-primary focus:ring-primary border-gray-300 rounded"
                       onchange="toggleSelectAll(this)">
                <label for="selectAll" class="ml-2 text-sm font-medium text-gray-700">Select All</label>
            </div>
            <ul class="divide-y divide-gray-200">
                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                        <div class="px-4 py-4 sm:px-6">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center space-x-4 flex-1">
                                    <div class="flex items-center">
                                        <input type="checkbox" 
                                               name="product_ids[]" 
                                               value="<?php echo e($product->id); ?>" 
                                               class="product-checkbox h-4 w-4 text-primary focus:ring-primary border-gray-300 rounded"
                                               onchange="updateBulkActionsBar()">
                                    </div>
                                    <div class="flex-shrink-0">
                                        <img src="<?php echo e(productImageUrl($product->image)); ?>" 
                                             alt="<?php echo e($product->name); ?>" 
                                             class="h-20 w-20 object-cover rounded"
                                             onerror="this.src='<?php echo e(url('images/placeholder.jpg')); ?>'; this.onerror=null;">
                                    </div>
                                    <div class="flex-1 min-w-0">
                                        <div class="flex items-center space-x-2">
                                            <p class="text-lg font-semibold text-gray-900"><?php echo e($product->name); ?></p>
                                            
                                            <!-- Status Badge -->
                                            <?php if($product->status === 'pending'): ?>
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                                    Pending
                                                </span>
                                            <?php elseif($product->status === 'approved'): ?>
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                    Approved
                                                </span>
                                            <?php elseif($product->status === 'rejected'): ?>
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                                    Rejected
                                                </span>
                                            <?php endif; ?>

                                            <?php if($product->is_active): ?>
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                    Active
                                                </span>
                                            <?php else: ?>
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                                    Inactive
                                                </span>
                                            <?php endif; ?>
                                            
                                            <?php if($product->is_featured): ?>
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-primary/10 text-primary">
                                                    Featured
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <?php if($product->store): ?>
                                            <p class="text-sm text-gray-600 mt-1">
                                                Store: <span class="font-medium"><?php echo e($product->store->business_name); ?></span>
                                            </p>
                                        <?php endif; ?>
                                        
                                        <p class="text-sm text-gray-500 mt-1">
                                            <?php if($product->categories->count() > 0): ?>
                                                <?php echo e($product->categories->pluck('name')->join(', ')); ?>

                                            <?php else: ?>
                                                <?php echo e($product->category->name ?? 'No Category'); ?>

                                            <?php endif; ?>
                                        </p>
                                        <p class="text-sm text-gray-500">
                                            Price: <?php echo e(currency($product->price)); ?> | Stock: <?php echo e($product->stock); ?>

                                            <?php if($product->on_sale): ?>
                                                | <span class="text-primary font-semibold">ON SALE</span>
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                </div>
                                <div class="flex items-center space-x-2">
                                    <!-- Approval Actions for Pending Products -->
                                    <?php if($product->status === 'pending'): ?>
                                        <form action="<?php echo e(route('admin.products.approve', $product)); ?>" method="POST" class="inline">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" 
                                                    onclick="return confirm('Approve this product? It will become active and visible to customers.')"
                                                    class="bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700 transition text-sm font-medium">
                                                Approve
                                            </button>
                                        </form>
                                        <button type="button" 
                                                onclick="showRejectModal(<?php echo e($product->id); ?>, '<?php echo e(addslashes($product->name)); ?>')"
                                                class="bg-red-600 text-white px-4 py-2 rounded-md hover:bg-red-700 transition text-sm font-medium">
                                            Reject
                                        </button>
                                    <?php endif; ?>
                                    
                                    <a href="<?php echo e(route('admin.products.edit', $product)); ?>" class="text-primary hover:text-primary-dark">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                        </svg>
                                    </a>
                                    <form action="<?php echo e(route('admin.products.destroy', $product)); ?>" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this product?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="text-red-600 hover:text-red-800">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                                            </svg>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>

        <div class="mt-6">
            <?php echo e($products->appends(request()->query())->links()); ?>

        </div>
    <?php else: ?>
        <div class="bg-white shadow rounded-lg p-8 text-center">
            <p class="text-gray-500 text-lg">
                <?php if(request('status') == 'pending'): ?>
                    No pending products found.
                <?php elseif(request('status') == 'approved'): ?>
                    No approved products found.
                <?php elseif(request('status') == 'rejected'): ?>
                    No rejected products found.
                <?php else: ?>
                    No products found.
                <?php endif; ?>
            </p>
            <a href="<?php echo e(route('admin.products.create')); ?>" class="mt-4 inline-block bg-primary text-white px-6 py-2 rounded hover:bg-primary-dark transition">
                Create Your First Product
            </a>
        </div>
    <?php endif; ?>
</div>

<!-- Reject Modal -->
<div id="rejectModal" class="hidden fixed z-50 inset-0 overflow-y-auto">
    <div class="flex items-center justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
        <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" onclick="closeRejectModal()"></div>
        
        <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
            <form action="" method="POST" id="rejectForm">
                <?php echo csrf_field(); ?>
                <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                    <div class="sm:flex sm:items-start">
                        <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-red-100 sm:mx-0 sm:h-10 sm:w-10">
                            <svg class="h-6 w-6 text-red-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </div>
                        <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left w-full">
                            <h3 class="text-lg leading-6 font-medium text-gray-900" id="rejectModalTitle">
                                Reject Product
                            </h3>
                            <div class="mt-4">
                                <p class="text-sm text-gray-500 mb-4">
                                    Are you sure you want to reject <strong id="rejectProductName"></strong>? This product will not be visible to customers.
                                </p>
                                <div>
                                    <label for="rejection_reason" class="block text-sm font-medium text-gray-700 mb-2">
                                        Reason (Optional)
                                    </label>
                                    <textarea id="rejection_reason" name="rejection_reason" rows="3" 
                                              class="shadow-sm focus:ring-primary focus:border-primary block w-full sm:text-sm border-gray-300 rounded-md"
                                              placeholder="Enter reason for rejection..."></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                    <button type="submit" class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-red-600 text-base font-medium text-white hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 sm:ml-3 sm:w-auto sm:text-sm">
                        Reject Product
                    </button>
                    <button type="button" onclick="closeRejectModal()" class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                        Cancel
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function showRejectModal(productId, productName) {
    const modal = document.getElementById('rejectModal');
    const form = document.getElementById('rejectForm');
    const productNameSpan = document.getElementById('rejectProductName');
    
    productNameSpan.textContent = productName;
    form.action = '<?php echo e(route("admin.products.reject", ":id")); ?>'.replace(':id', productId);
    
    modal.classList.remove('hidden');
    document.body.style.overflow = 'hidden';
}

function closeRejectModal() {
    const modal = document.getElementById('rejectModal');
    modal.classList.add('hidden');
    document.body.style.overflow = '';
    document.getElementById('rejection_reason').value = '';
}

// Bulk Actions Functions
function toggleSelectAll(checkbox) {
    const productCheckboxes = document.querySelectorAll('.product-checkbox');
    productCheckboxes.forEach(cb => {
        cb.checked = checkbox.checked;
    });
    updateBulkActionsBar();
}

function updateBulkActionsBar() {
    const checkedBoxes = document.querySelectorAll('.product-checkbox:checked');
    const selectedCount = checkedBoxes.length;
    const bulkActionsBar = document.getElementById('bulkActionsBar');
    const selectedCountSpan = document.getElementById('selectedCount');
    const selectAllCheckbox = document.getElementById('selectAll');
    
    selectedCountSpan.textContent = selectedCount;
    
    if (selectedCount > 0) {
        bulkActionsBar.classList.remove('hidden');
    } else {
        bulkActionsBar.classList.add('hidden');
    }
    
    // Update select all checkbox state
    const totalCheckboxes = document.querySelectorAll('.product-checkbox').length;
    selectAllCheckbox.checked = selectedCount === totalCheckboxes && totalCheckboxes > 0;
    selectAllCheckbox.indeterminate = selectedCount > 0 && selectedCount < totalCheckboxes;
}

function applyBulkAction() {
    const checkedBoxes = document.querySelectorAll('.product-checkbox:checked');
    const action = document.getElementById('bulkActionSelect').value;
    
    if (checkedBoxes.length === 0) {
        alert('Please select at least one product.');
        return;
    }
    
    if (!action) {
        alert('Please select an action.');
        return;
    }
    
    // Confirm destructive actions
    if (action === 'delete') {
        if (!confirm(`Are you sure you want to delete ${checkedBoxes.length} product(s)? This action cannot be undone.`)) {
            return;
        }
    } else if (action === 'reject') {
        if (!confirm(`Are you sure you want to reject ${checkedBoxes.length} product(s)?`)) {
            return;
        }
    }
    
    // Collect selected product IDs
    const productIds = Array.from(checkedBoxes).map(cb => cb.value);
    
    // Create form and submit
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = '<?php echo e(route("admin.products.bulk-action")); ?>';
    
    // Add CSRF token
    const csrfInput = document.createElement('input');
    csrfInput.type = 'hidden';
    csrfInput.name = '_token';
    csrfInput.value = '<?php echo e(csrf_token()); ?>';
    form.appendChild(csrfInput);
    
    // Add product IDs
    productIds.forEach(id => {
        const input = document.createElement('input');
        input.type = 'hidden';
        input.name = 'product_ids[]';
        input.value = id;
        form.appendChild(input);
    });
    
    // Add action
    const actionInput = document.createElement('input');
    actionInput.type = 'hidden';
    actionInput.name = 'action';
    actionInput.value = action;
    form.appendChild(actionInput);
    
    // Add status to maintain current tab
    <?php if(request('status')): ?>
        const statusInput = document.createElement('input');
        statusInput.type = 'hidden';
        statusInput.name = 'status';
        statusInput.value = '<?php echo e(request('status')); ?>';
        form.appendChild(statusInput);
    <?php endif; ?>
    
    document.body.appendChild(form);
    form.submit();
}

function clearSelection() {
    const productCheckboxes = document.querySelectorAll('.product-checkbox');
    productCheckboxes.forEach(cb => {
        cb.checked = false;
    });
    document.getElementById('selectAll').checked = false;
    document.getElementById('selectAll').indeterminate = false;
    document.getElementById('bulkActionSelect').value = '';
    updateBulkActionsBar();
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\TrendzTrade\resources\views/admin/products/index.blade.php ENDPATH**/ ?>