<?php $__env->startSection('title', 'Home'); ?>

<?php $__env->startSection('content'); ?>
<style>
    /* Green outline text effect - exact match */
    .text-outline-green {
        color: #000;
        -webkit-text-stroke: 2px #00ff00;
        text-stroke: 2px #00ff00;
        font-weight: 900;
        letter-spacing: 1px;
    }
    
    /* Category text styling */
    .category-text {
        font-size: 4rem;
        font-weight: 900;
        letter-spacing: 2px;
        line-height: 1.1;
    }
    
    .category-text.highlight {
        color: #33B8A6;
    }
    
    .categories-label {
        font-size: 6rem;
        font-weight: 300;
        color: #d1d5db;
        -webkit-text-stroke: 1px #d1d5db;
        text-stroke: 1px #d1d5db;
        opacity: 0.5;
        letter-spacing: 4px;
    }
    
    /* Product carousel */
    .product-carousel {
        scroll-behavior: smooth;
        scrollbar-width: none;
        -ms-overflow-style: none;
    }
    .product-carousel::-webkit-scrollbar {
        display: none;
    }
    
    /* Product image hover slide */
    .product-image-container {
        position: relative;
    }
    .product-images-wrapper {
        position: relative;
        width: 100%;
        height: 100%;
        display: flex;
        transition: transform 0.5s ease-in-out;
    }
    .product-image {
        min-width: 100%;
        height: 100%;
        object-fit: cover;
        display: block;
    }
    .product-image-container:hover .product-images-wrapper {
        animation: slideImages 3s infinite;
    }
    @keyframes slideImages {
        0%, 20% {
            transform: translateX(0);
        }
        25%, 45% {
            transform: translateX(-100%);
        }
        50%, 70% {
            transform: translateX(-200%);
        }
        75%, 95% {
            transform: translateX(-300%);
        }
        100% {
            transform: translateX(0);
        }
    }
    .product-image-container[data-image-count="1"]:hover .product-images-wrapper {
        animation: none;
    }
    .product-image-container[data-image-count="2"]:hover .product-images-wrapper {
        animation: slideImages2 3s infinite;
    }
    @keyframes slideImages2 {
        0%, 45% {
            transform: translateX(0);
        }
        50%, 95% {
            transform: translateX(-100%);
        }
        100% {
            transform: translateX(0);
        }
    }
    .product-image-container[data-image-count="3"]:hover .product-images-wrapper {
        animation: slideImages3 4s infinite;
    }
    @keyframes slideImages3 {
        0%, 30% {
            transform: translateX(0);
        }
        33%, 63% {
            transform: translateX(-100%);
        }
        66%, 96% {
            transform: translateX(-200%);
        }
        100% {
            transform: translateX(0);
        }
    }
    
    /* Section headers */
    .section-header {
        font-size: 2rem;
        font-weight: 900;
        letter-spacing: 2px;
    }
    @media (min-width: 640px) {
        .section-header {
            font-size: 2.5rem;
        }
    }
    @media (min-width: 768px) {
        .section-header {
            font-size: 3rem;
        }
    }
    @media (min-width: 1024px) {
        .section-header {
            font-size: 3.5rem;
        letter-spacing: 3px;
        }
    }
    
    /* Dark hero section background - concrete texture */
    .hero-dark-bg {
        background: #1a1f1a;
        background-image: 
            radial-gradient(circle at 20% 50%, rgba(0, 255, 0, 0.03) 0%, transparent 50%),
            radial-gradient(circle at 80% 80%, rgba(0, 255, 0, 0.03) 0%, transparent 50%),
            repeating-linear-gradient(0deg, transparent, transparent 1px, rgba(0, 0, 0, 0.15) 1px, rgba(0, 0, 0, 0.15) 2px),
            repeating-linear-gradient(90deg, transparent, transparent 1px, rgba(0, 0, 0, 0.15) 1px, rgba(0, 0, 0, 0.15) 2px);
        position: relative;
    }
    
    /* Instead of neon, define primary color class for hero */
    .hero-primary {
        color: <?php echo e($primaryColor ?? '#ff5349'); ?>;
    }
    /* Remove any text-shadow/glow from headings */
    
    /* Social media sidebar */
    .social-sidebar {
        writing-mode: vertical-rl;
        text-orientation: mixed;
    }
    
    /* Logo outline effect - using primary color */
    .logo-outline {
        color: <?php echo e($primaryColor ?? '#ff5349'); ?>;
    }
    
    /* Spinning circular text animation */
    @keyframes spin-text {
        from {
            transform: rotate(0deg);
        }
        to {
            transform: rotate(360deg);
        }
    }
    
    .spinning-badge {
        animation: spin-text 20s linear infinite;
    }
    
    /* Hero slider styles */
    .hero-slide {
        opacity: 0;
        transition: opacity 0.8s ease-in-out;
        position: absolute;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
    }
    
    .hero-slide.active {
        opacity: 1;
        position: absolute;
    }
    
    /* Mobile: Fixed height for slider container */
    @media (max-width: 767px) {
        .hero-slider-container {
            min-height: 100vh;
            height: auto;
            position: relative;
        }
        .hero-content-left {
            min-height: 50vh;
            padding: 1.5rem 1rem !important;
        }
        .hero-image-right {
            min-height: 40vh;
        }
    }
    
    /* Extra small mobile devices */
    @media (max-width: 375px) {
        .hero-content-left {
            padding: 1rem 0.75rem !important;
        }
    }
    
    .hero-content-left {
        transition: opacity 0.8s ease-in-out, transform 0.8s ease-in-out;
    }
    
    .hero-image-right {
        transition: opacity 0.8s ease-in-out, transform 0.8s ease-in-out;
    }
    
    /* Black background sliding animation */
    .hero-title-bg {
        position: relative;
        overflow: hidden;
        display: inline-block;
    }
    
    .hero-title-bg::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background-color: <?php echo e($primaryColor ?? '#ff5349'); ?>;
        transition: left 0.8s ease-in-out;
        z-index: -1;
    }
    
    /* Reset animation when slide becomes active */
    .hero-slide:not(.active) .hero-title-bg::before {
        left: -100%;
        transition: none;
    }
    
    .hero-slide.active .hero-title-bg::before {
        left: 0;
        transition: left 0.8s ease-in-out;
    }
    
    .hero-title-text {
        position: relative;
        z-index: 1;
        padding: 0.5rem 1rem;
    }
</style>

<!-- Dark Hero Banner Section - 3 Slide Slider -->
<section class="hero-slider-container min-h-[90vh] md:h-[90vh] flex relative hero-dark-bg overflow-hidden">
    <?php if($sliders->count() > 0): ?>
        <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="hero-slide <?php echo e($index === 0 ? 'active' : ''); ?>" data-slide="<?php echo e($index); ?>">
            <div class="h-full flex flex-col md:flex-row relative">
                <!-- Left: Promotional Content -->
                <div class="w-full md:w-1/2 flex items-center px-3 sm:px-6 md:pl-20 md:pr-12 py-8 sm:py-10 md:py-0 relative z-10 hero-content-left min-h-[50vh] md:h-full md:min-h-0 overflow-y-auto" style="background-image: url('<?php echo e(productImageUrl($slider->image)); ?>'); background-size: cover; background-position: center;">
                    <div class="absolute inset-0 bg-black bg-opacity-95 z-0"></div>
                    <div class="space-y-3 sm:space-y-4 md:space-y-6 relative z-10 w-full">
                        <div>
                            <?php if($slider->price && $slider->price > 0): ?>
                                <p class="hero-primary text-base sm:text-lg md:text-xl lg:text-2xl font-bold mb-1.5 sm:mb-2">FROM <?php echo e(currency($slider->price)); ?></p>
                            <?php endif; ?>
                            <h1 class="hero-title-bg text-white text-2xl sm:text-3xl md:text-4xl lg:text-5xl xl:text-7xl font-black mb-2 sm:mb-3 leading-tight inline-block">
                                <span class="hero-title-text"><?php echo e($slider->title); ?></span>
                            </h1>
                            <p class="text-white text-sm sm:text-base md:text-lg font-bold mb-3 sm:mb-4 md:mb-6"><?php echo e($slider->subtitle); ?></p>
                        </div>
                        
                        <p class="text-white text-xs sm:text-sm md:text-base leading-relaxed max-w-md">
                            <?php echo $slider->description; ?>

                        </p>
                        
                        <a href="<?php echo e($slider->link ? (substr($slider->link, 0, 4) === 'http' ? $slider->link : url($slider->link)) : route('products.index')); ?>" 
                           class="inline-block border border-white bg-black text-white px-4 sm:px-6 md:px-8 py-2 sm:py-2.5 md:py-3 text-xs sm:text-sm font-semibold hover:bg-gray-900 transition duration-300 mt-3 sm:mt-4 md:mt-6">
                            DISCOVER NOW →
                        </a>
                    </div>
                </div>
                
                <!-- Right: Lifestyle Image -->
                <div class="w-full md:w-1/2 relative overflow-hidden hero-image-right min-h-[40vh] sm:min-h-[45vh] md:h-full md:min-h-0">
                    <img src="<?php echo e(productImageUrl($slider->image)); ?>" 
                         alt="<?php echo e($slider->title); ?>" 
                         class="w-full h-full object-cover"
                         onerror="this.src='<?php echo e(url('images/placeholder.jpg')); ?>'; this.onerror=null;">
                    
                    <!-- Circular badge overlay - Perfect SVG with spinning circular text -->
                    <div class="absolute top-2 right-2 sm:top-4 sm:right-4 md:top-6 md:right-6 w-12 h-12 sm:w-16 sm:h-16 md:w-28 md:h-28 z-20">
                        <svg viewBox="0 0 100 100" width="100%" height="100%" class="spinning-badge">
                            <circle cx="50" cy="50" r="45" fill="<?php echo e($primaryColor ?? '#ff5349'); ?>" stroke="black" stroke-width="3"/>
                            <defs>
                                <path id="badge-circle-<?php echo e($index); ?>" d="M 50,50 m -35,0 a 35,35 0 1,1 70,0 a 35,35 0 1,1 -70,0"/>
                            </defs>
                            <text fill="black" font-size="6.5" font-weight="900" font-family="Arial, sans-serif" letter-spacing="0.5">
                                <textPath href="#badge-circle-<?php echo e($index); ?>" startOffset="0%">
                                    BUY NOW . SELL NOW . • BUY NOW . SELL NOW . • 
                                </textPath>
                            </text>
                        </svg>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
        <!-- Fallback if no sliders exist -->
        <div class="h-full flex items-center justify-center">
            <p class="text-white text-xl">No sliders available. Please create sliders in the admin panel.</p>
        </div>
    <?php endif; ?>
    
    <!-- Social Media Sidebar (Right Edge) - EXACT POSITION -->
    <div class="hidden lg:flex absolute right-4 top-1/2 transform -translate-y-1/2 flex-col gap-6 z-20">
        <?php if(!empty($whatsappUrl)): ?>
            <a href="<?php echo e($whatsappUrl); ?>" target="_blank" rel="noopener noreferrer" class="social-sidebar text-white text-xs font-bold hover:text-primary transition">WHATSAPP</a>
        <?php endif; ?>
        <?php if(!empty($facebookUrl)): ?>
            <a href="<?php echo e($facebookUrl); ?>" target="_blank" rel="noopener noreferrer" class="social-sidebar text-white text-xs font-bold hover:text-primary transition">FACEBOOK</a>
        <?php endif; ?>
        <?php if(!empty($instagramUrl)): ?>
            <a href="<?php echo e($instagramUrl); ?>" target="_blank" rel="noopener noreferrer" class="social-sidebar text-white text-xs font-bold hover:text-primary transition">INSTAGRAM</a>
        <?php endif; ?>
        <?php if(!empty($youtubeUrl)): ?>
            <a href="<?php echo e($youtubeUrl); ?>" target="_blank" rel="noopener noreferrer" class="social-sidebar text-white text-xs font-bold hover:text-primary transition">YOUTUBE</a>
        <?php endif; ?>
        <?php if(!empty($tiktokUrl)): ?>
            <a href="<?php echo e($tiktokUrl); ?>" target="_blank" rel="noopener noreferrer" class="social-sidebar text-white text-xs font-bold hover:text-primary transition">TIKTOK</a>
        <?php endif; ?>
        <?php if(!empty($snapchatUrl)): ?>
            <a href="<?php echo e($snapchatUrl); ?>" target="_blank" rel="noopener noreferrer" class="social-sidebar text-white text-xs font-bold hover:text-primary transition">SNAPCHAT</a>
        <?php endif; ?>
    </div>
    
    <!-- Navigation Arrows (Bottom Right) - In White Box -->
    <div class="absolute bottom-2 right-2 sm:bottom-4 sm:right-4 md:bottom-6 md:right-6 border border-white bg-black/60 backdrop-blur-sm p-0.5 sm:p-1 flex gap-0.5 sm:gap-1 z-30 rounded">
        <button onclick="changeHeroSlide(-1)" class="w-8 h-8 sm:w-9 sm:h-9 bg-transparent text-white flex items-center justify-center hover:bg-white hover:text-black active:bg-white/80 transition rounded" aria-label="Previous slide">
            <svg class="w-3.5 h-3.5 sm:w-4 sm:h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
            </svg>
        </button>
        <button onclick="changeHeroSlide(1)" class="w-8 h-8 sm:w-9 sm:h-9 bg-transparent text-white flex items-center justify-center hover:bg-white hover:text-black active:bg-white/80 transition rounded" aria-label="Next slide">
            <svg class="w-3.5 h-3.5 sm:w-4 sm:h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
            </svg>
        </button>
    </div>
</section>

<!-- Top Categories Section - 12 Grid Layout (Jumia Style - 6 Columns) -->
<?php if(isset($topCategories) && $topCategories->count() > 0): ?>
<section class="bg-white shadow-sm rounded-lg mx-1 sm:mx-2 md:mx-4 my-2 sm:my-3 md:my-4 p-1.5 sm:p-2 md:p-4">
    <div class="grid grid-cols-3 sm:grid-cols-4 md:grid-cols-6 gap-1.5 sm:gap-2 md:gap-4">
        <!-- Slot 1-5: Categories -->
        <?php $__currentLoopData = $topCategories->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(route('products.index', ['category' => $category->id])); ?>" class="flex flex-col items-center group cursor-pointer h-full relative rounded-lg overflow-hidden hover:shadow-lg transition-shadow">
                <div class="w-full aspect-square relative">
                    <?php if($category->image): ?>
                        <img src="<?php echo e(productImageUrl($category->image)); ?>" alt="<?php echo e($category->name); ?>" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-300">
                    <?php else: ?>
                         <div class="w-full h-full flex items-center justify-center bg-gray-100 text-gray-300">
                            <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"></path>
                            </svg>
                         </div>
                    <?php endif; ?>
                    <!-- Text Overlay -->
                    <div class="absolute inset-x-0 bottom-0 bg-black bg-opacity-60 py-1.5 px-1 backdrop-blur-[2px]">
                        <span class="block text-white text-xs md:text-sm font-bold text-center truncate w-full"><?php echo e($category->name); ?></span>
                    </div>
                </div>
            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <!-- Slot 6: Sell on Trendz (Custom) -->
        <a href="<?php echo e(route('store.register')); ?>" class="flex flex-col items-center group cursor-pointer h-full relative rounded-lg overflow-hidden hover:shadow-lg transition-shadow">
            <div class="w-full aspect-square bg-orange-600 relative flex items-center justify-center">
                 <div class="absolute inset-0 bg-gradient-to-br from-orange-500 to-red-600"></div>
                 <div class="relative z-10 text-center p-1">
                    <span class="block text-white font-black text-xl md:text-2xl leading-none drop-shadow-md">SELL</span>
                    <span class="block text-white font-bold text-[10px] md:text-xs uppercase tracking-widest my-1">ON</span>
                    <span class="block text-white font-black text-lg md:text-xl leading-none drop-shadow-md">TRENDZ</span>
                 </div>
            </div>
        </a>

        <!-- Slot 7-11: Categories (Offset 5) -->
        <?php $__currentLoopData = $topCategories->skip(5)->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(route('products.index', ['category' => $category->id])); ?>" class="flex flex-col items-center group cursor-pointer h-full relative rounded-lg overflow-hidden hover:shadow-lg transition-shadow">
                <div class="w-full aspect-square relative">
                    <?php if($category->image): ?>
                        <img src="<?php echo e(productImageUrl($category->image)); ?>" alt="<?php echo e($category->name); ?>" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-300">
                    <?php else: ?>
                         <div class="w-full h-full flex items-center justify-center bg-gray-100 text-gray-300">
                            <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"></path>
                            </svg>
                         </div>
                    <?php endif; ?>
                    <!-- Text Overlay -->
                    <div class="absolute inset-x-0 bottom-0 bg-black bg-opacity-60 py-1.5 px-1 backdrop-blur-[2px]">
                        <span class="block text-white text-xs md:text-sm font-bold text-center truncate w-full"><?php echo e($category->name); ?></span>
                    </div>
                </div>
            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <!-- Slot 12: Big Discount (Custom) -->
        <a href="<?php echo e(route('products.index', ['big_sale' => 'true'])); ?>" class="flex flex-col items-center group cursor-pointer h-full relative rounded-lg overflow-hidden hover:shadow-lg transition-shadow">
            <div class="w-full aspect-square bg-yellow-400 relative flex items-center justify-center">
                 <div class="absolute inset-0 bg-gradient-to-br from-yellow-400 to-orange-500"></div>
                 <div class="relative z-10 text-center transform group-hover:scale-110 transition-transform duration-300">
                    <span class="block text-white font-black text-2xl md:text-3xl leading-none drop-shadow-md text-shadow-sm">BIG</span>
                    <span class="block text-white font-black text-2xl md:text-3xl leading-none drop-shadow-md text-shadow-sm">SALE</span>
                 </div>
            </div>
        </a>
    </div>
</section>
<?php endif; ?>

<!-- Shop Trending Section: Jumia Style -->
<?php if($trendingProducts->count() > 0): ?>
<section class="bg-gray-100 py-3 sm:py-4 mb-3 sm:mb-4">
    <div class="container mx-auto px-2 sm:px-3 md:px-4">
        <div class="bg-white rounded shadow-sm overflow-hidden">
            <!-- Header -->
            <div class="px-3 sm:px-4 py-2 sm:py-3 flex justify-between items-center" style="background-color: <?php echo e($primaryColor ?? '#ff5349'); ?>;">
                <h3 class="text-white font-bold text-base sm:text-lg md:text-xl uppercase">Trending Now</h3>
                <a href="<?php echo e(route('home')); ?>" class="text-white text-xs sm:text-sm font-medium hover:underline flex items-center gap-1">
                Home
                <svg class="w-3 h-3 sm:w-4 sm:h-4" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h2a1 1 0 001-1v-2a1 1 0 011-1h2a1 1 0 011 1v2a1 1 0 001 1h2a1 1 0 001-1v-6.586l.293.293a1 1 0 001.414-1.414l-7-7z"></path></svg>
            </a>
            </div>
            
            <!-- Products Grid -->
            <div class="p-1.5 sm:p-2 md:p-4">
                 <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-6 gap-1.5 sm:gap-2 md:gap-4">
                    <?php $__currentLoopData = $trendingProducts->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="group relative bg-white hover:shadow-lg transition-shadow duration-300 rounded-md p-2 border border-transparent hover:border-gray-200">
                            <a href="<?php echo e(route('products.show', $product->slug)); ?>" class="block h-full pb-10">
                                <!-- Image -->
                                <div class="relative aspect-[3/4] mb-2 overflow-hidden rounded bg-gray-100">
                                    <img src="<?php echo e(productImageUrl($product->image)); ?>" alt="<?php echo e($product->name); ?>" class="w-full h-full object-cover group-hover:scale-105 transition duration-300">
                                    <?php if($product->compare_price): ?>
                                        <span class="absolute top-1 right-1 bg-red-100 text-red-600 text-[10px] font-bold px-1.5 py-0.5 rounded">
                                            -<?php echo e(round((($product->compare_price - $product->price) / $product->compare_price) * 100)); ?>%
                                        </span>
                                    <?php endif; ?>
                                </div>
                                
                                <!-- Details -->
                                <div class="space-y-1">
                                    <h4 class="text-xs md:text-sm text-gray-700 line-clamp-2 min-h-[2.5em]" title="<?php echo e($product->name); ?>"><?php echo e($product->name); ?></h4>
                                    <div class="flex flex-col">
                                        <span class="text-sm md:text-base font-bold text-gray-900"><?php echo e(currency($product->price)); ?></span>
                                        <?php if($product->compare_price): ?>
                                            <span class="text-xs text-gray-400 line-through"><?php echo e(currency($product->compare_price)); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </a>
                            
                            <!-- Add to Cart -->
                                    <div class="absolute bottom-2 left-2 right-2 opacity-100 md:opacity-0 md:group-hover:opacity-100 transition-opacity duration-200">
                                         <form action="<?php echo e(route('cart.store')); ?>" method="POST" class="add-to-cart-form" onclick="event.stopPropagation();">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                            <input type="hidden" name="quantity" value="1">
                                            <button type="submit" class="w-full text-white text-xs md:text-sm font-bold py-1.5 rounded hover:bg-opacity-90 transition shadow-sm uppercase tracking-wide" style="background-color: <?php echo e($primaryColor ?? '#ff5349'); ?>;">
                                                Add To Cart
                                            </button>
                                        </form>
                                    </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                 </div>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Shop Top Picks Section: Jumia Style -->
<?php if(($bannerActiveStatus['featured'] ?? true) || ($showFeaturedProductsSection ?? true)): ?>
    <?php if($showFeaturedProductsSection ?? true && $topPicks->count() > 0): ?>
    <section class="bg-gray-100 py-3 sm:py-4 mb-3 sm:mb-4">
        <div class="container mx-auto px-2 sm:px-3 md:px-4">
            <div class="bg-white rounded shadow-sm overflow-hidden">
                <!-- Header -->
                <div class="px-3 sm:px-4 py-2 sm:py-3 flex justify-between items-center" style="background-color: <?php echo e($primaryColor ?? '#ff5349'); ?>;">
                    <h3 class="text-white font-bold text-base sm:text-lg md:text-xl uppercase">Featured Products</h3>
                    <a href="<?php echo e(route('products.index', ['featured' => 1])); ?>" class="text-white text-xs sm:text-sm font-medium hover:underline flex items-center gap-1">
                        See All 
                        <svg class="w-3 h-3 sm:w-4 sm:h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
                    </a>
                </div>
                
                <!-- Products Grid -->
                <div class="p-1.5 sm:p-2 md:p-4">
                     <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-6 gap-1.5 sm:gap-2 md:gap-4">
                        <?php $__currentLoopData = $topPicks->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="group relative bg-white hover:shadow-lg transition-shadow duration-300 rounded-md p-2 border border-transparent hover:border-gray-200">
                                <a href="<?php echo e(route('products.show', $product->slug)); ?>" class="block h-full pb-10">
                                    <!-- Image -->
                                    <div class="relative aspect-[3/4] mb-2 overflow-hidden rounded bg-gray-100">
                                        <img src="<?php echo e(productImageUrl($product->image)); ?>" alt="<?php echo e($product->name); ?>" class="w-full h-full object-cover group-hover:scale-105 transition duration-300">
                                        <?php if($product->compare_price): ?>
                                            <span class="absolute top-1 right-1 bg-red-100 text-red-600 text-[10px] font-bold px-1.5 py-0.5 rounded">
                                                -<?php echo e(round((($product->compare_price - $product->price) / $product->compare_price) * 100)); ?>%
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <!-- Details -->
                                    <div class="space-y-1">
                                        <h4 class="text-xs md:text-sm text-gray-700 line-clamp-2 min-h-[2.5em]" title="<?php echo e($product->name); ?>"><?php echo e($product->name); ?></h4>
                                        <div class="flex flex-col">
                                            <span class="text-sm md:text-base font-bold text-gray-900"><?php echo e(currency($product->price)); ?></span>
                                            <?php if($product->compare_price): ?>
                                                <span class="text-xs text-gray-400 line-through"><?php echo e(currency($product->compare_price)); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </a>
                                
                                <!-- Add to Cart -->
                                <div class="absolute bottom-2 left-2 right-2 opacity-100 md:opacity-0 md:group-hover:opacity-100 transition-opacity duration-200">
                                     <form action="<?php echo e(route('cart.store')); ?>" method="POST" class="add-to-cart-form" onclick="event.stopPropagation();">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                        <input type="hidden" name="quantity" value="1">
                                        <button type="submit" class="w-full text-white text-xs md:text-sm font-bold py-1.5 rounded hover:bg-opacity-90 transition shadow-sm uppercase tracking-wide" style="background-color: <?php echo e($primaryColor ?? '#ff5349'); ?>;">
                                            Add To Cart
                                        </button>
                                    </form>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                     </div>
                </div>
            </div>
        </div>
    </section>
    <?php endif; ?>
<?php endif; ?>

<!-- Clearance Sale Marquee Banner -->
<section class="bg-black py-3 sm:py-4 overflow-hidden">
    <div class="marquee-container">
        <div class="marquee-content">
            <span class="text-white text-sm sm:text-base md:text-lg lg:text-xl xl:text-2xl" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">BUY NOW</span>
            <span class="font-bold text-sm sm:text-base md:text-lg lg:text-xl xl:text-2xl" style="color: <?php echo e($primaryColor ?? '#ff5349'); ?>;">. SELL NOW .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">BUY NOW</span>
            <span class="font-bold" style="color: <?php echo e($primaryColor ?? '#ff5349'); ?>;">. SELL NOW .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">BUY NOW</span>
            <span class="font-bold" style="color: <?php echo e($primaryColor ?? '#ff5349'); ?>;">. SELL NOW .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">BUY NOW</span>
            <span class="font-bold" style="color: <?php echo e($primaryColor ?? '#ff5349'); ?>;">. SELL NOW .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">BUY NOW</span>
            <span class="font-bold" style="color: <?php echo e($primaryColor ?? '#ff5349'); ?>;">. SELL NOW .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">BUY NOW</span>
            <span class="font-bold" style="color: <?php echo e($primaryColor ?? '#ff5349'); ?>;">. SELL NOW .</span>
        </div>
        <div class="marquee-content" aria-hidden="true">
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">BUY NOW</span>
            <span class="font-bold" style="color: <?php echo e($primaryColor ?? '#ff5349'); ?>;">. SELL NOW .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">BUY NOW</span>
            <span class="font-bold" style="color: <?php echo e($primaryColor ?? '#ff5349'); ?>;">. SELL NOW .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">BUY NOW</span>
            <span class="font-bold" style="color: <?php echo e($primaryColor ?? '#ff5349'); ?>;">. SELL NOW .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">BUY NOW</span>
            <span class="font-bold" style="color: <?php echo e($primaryColor ?? '#ff5349'); ?>;">. SELL NOW .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">BUY NOW</span>
            <span class="font-bold" style="color: <?php echo e($primaryColor ?? '#ff5349'); ?>;">. SELL NOW .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">BUY NOW</span>
            <span class="font-bold" style="color: <?php echo e($primaryColor ?? '#ff5349'); ?>;">. SELL NOW .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">BUY NOW</span>
            <span class="font-bold" style="color: <?php echo e($primaryColor ?? '#ff5349'); ?>;">. SELL NOW .</span>
        </div>
    </div>
    <style>
        .marquee-container {
            display: flex;
            overflow: hidden;
            white-space: nowrap;
        }
        .marquee-content {
            display: inline-flex;
            align-items: center;
            gap: 1.5rem;
            animation: marquee 30s linear infinite;
            font-weight: 900;
            text-transform: uppercase;
            letter-spacing: 0.1em;
        }
        @media (min-width: 640px) {
            .marquee-content {
                gap: 2rem;
            }
        }
        @media (min-width: 768px) {
            .marquee-content {
                gap: 2.5rem;
            }
        }
        @media (min-width: 1024px) {
            .marquee-content {
                gap: 3rem;
            }
        }
        .marquee-content span {
            flex-shrink: 0;
        }
        @keyframes marquee {
            0% {
                transform: translateX(0);
            }
            100% {
                transform: translateX(-50%);
            }
        }
    </style>
</section>

<!-- Shop For Her / Shop For Him Split Section -->
<?php if(($bannerActiveStatus['shop_for_her'] ?? true) || ($bannerActiveStatus['shop_for_him'] ?? true)): ?>
<section class="py-4 sm:py-6 md:py-8 lg:py-12 bg-gradient-to-b from-gray-50 to-white">
    <div class="max-w-7xl mx-auto px-3 sm:px-4 md:px-6 lg:px-8">
        <div class="flex flex-col md:flex-row gap-4 sm:gap-6 md:gap-8">
            <!-- Left: Shop For Her -->
            <?php if($bannerActiveStatus['shop_for_her'] ?? true): ?>
            <div class="w-full md:w-1/2 relative group overflow-hidden rounded-xl sm:rounded-2xl shadow-lg sm:shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:-translate-y-1 md:hover:-translate-y-2">
                <!-- Background Image with Overlay -->
                <div class="relative h-[300px] sm:h-[350px] md:h-[450px] lg:h-[550px] overflow-hidden">
                    <img src="<?php echo e(productImageUrl($bannerSettings['shop_for_her']['banner_image'])); ?>" 
                         alt="Shop For Her" 
                         class="absolute inset-0 w-full h-full object-cover transition-transform duration-700 group-hover:scale-110"
                         onerror="this.src='https://images.unsplash.com/photo-1490481651871-ab68de25d43d?w=1200&h=1600&fit=crop'; this.onerror=null;">
                    
                    <!-- Gradient Overlay -->
                    <div class="absolute inset-0 bg-gradient-to-br from-pink-600/80 via-purple-600/70 to-pink-500/80"></div>
                    <div class="absolute inset-0 bg-gradient-to-t from-black/90 via-black/40 to-transparent"></div>
                    
                    <!-- Decorative Pattern -->
                    <div class="absolute inset-0 opacity-10" style="background-image: radial-gradient(circle at 2px 2px, white 1px, transparent 0); background-size: 40px 40px;"></div>
                    
                    <!-- Content -->
                    <div class="absolute inset-0 flex flex-col justify-between p-4 sm:p-6 md:p-8 lg:p-12 text-white">
                        <div class="space-y-3 sm:space-y-4 md:space-y-6">
                            <!-- Badge -->
                            <?php if($bannerSettings['shop_for_her']['banner_subtitle']): ?>
                            <div class="inline-block">
                                <span class="bg-white/30 backdrop-blur-md text-white px-3 sm:px-4 md:px-5 py-1.5 sm:py-2 md:py-2.5 rounded-full text-[10px] sm:text-xs md:text-sm font-bold uppercase tracking-widest border border-white/30 shadow-lg">
                                    <?php echo e($bannerSettings['shop_for_her']['banner_subtitle']); ?>

                                </span>
                            </div>
                            <?php endif; ?>
                            
                            <!-- Title with Better Typography -->
                            <?php if($bannerSettings['shop_for_her']['banner_title']): ?>
                            <div class="space-y-1 sm:space-y-2 md:space-y-3">
                                <h3 class="text-3xl sm:text-4xl md:text-5xl lg:text-6xl xl:text-7xl 2xl:text-8xl font-black leading-[0.9] tracking-tight">
                                    <span class="block text-white drop-shadow-2xl">SHOP</span>
                                    <span class="block text-white drop-shadow-2xl">FOR</span>
                                    <span class="block text-white drop-shadow-2xl">HER</span>
                                </h3>
                            </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="space-y-3 sm:space-y-4 md:space-y-6">
                            <!-- Description -->
                            <?php if($bannerSettings['shop_for_her']['banner_description']): ?>
                            <p class="text-white/95 text-sm sm:text-base md:text-lg max-w-md leading-relaxed font-medium drop-shadow-lg">
                                <?php echo e($bannerSettings['shop_for_her']['banner_description']); ?>

                            </p>
                            <?php endif; ?>
                            
                            <!-- CTA Button -->
                            <a href="<?php echo e($bannerSettings['shop_for_her']['banner_link'] ?? route('products.index', ['category' => $categories->where('name', 'like', '%women%')->first()->id ?? ''])); ?>" 
                               class="inline-flex items-center gap-2 sm:gap-3 bg-white text-gray-900 px-4 sm:px-6 md:px-8 py-2.5 sm:py-3 md:py-4 rounded-lg sm:rounded-xl font-bold text-sm sm:text-base md:text-lg hover:bg-gray-50 transition-all duration-300 shadow-xl sm:shadow-2xl hover:shadow-white/50 transform hover:scale-105 group/btn">
                                <span>DISCOVER NOW</span>
                                <svg class="w-4 h-4 sm:w-5 sm:h-5 md:w-6 md:h-6 transition-transform duration-300 group-hover/btn:translate-x-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            
            <!-- Right: Shop For Him -->
            <?php if($bannerActiveStatus['shop_for_him'] ?? true): ?>
            <div class="w-full <?php echo e(($bannerActiveStatus['shop_for_her'] ?? true) ? 'md:w-1/2' : 'md:w-full'); ?> relative group overflow-hidden rounded-xl sm:rounded-2xl shadow-lg sm:shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:-translate-y-1 md:hover:-translate-y-2">
                <!-- Background Image with Overlay -->
                <div class="relative h-[300px] sm:h-[350px] md:h-[450px] lg:h-[550px] overflow-hidden">
                    <img src="<?php echo e(productImageUrl($bannerSettings['shop_for_him']['banner_image'])); ?>" 
                         alt="Shop For Him" 
                         class="absolute inset-0 w-full h-full object-cover transition-transform duration-700 group-hover:scale-110"
                         onerror="this.src='https://images.unsplash.com/photo-1617137968427-85924c800a22?w=1200&h=1600&fit=crop'; this.onerror=null;">
                    
                    <!-- Gradient Overlay -->
                    <div class="absolute inset-0 bg-gradient-to-br from-gray-800/85 via-blue-900/75 to-gray-700/85"></div>
                    <div class="absolute inset-0 bg-gradient-to-t from-black/90 via-black/40 to-transparent"></div>
                    
                    <!-- Decorative Pattern -->
                    <div class="absolute inset-0 opacity-10" style="background-image: radial-gradient(circle at 2px 2px, white 1px, transparent 0); background-size: 40px 40px;"></div>
                    
                    <!-- Content -->
                    <div class="absolute inset-0 flex flex-col justify-between p-4 sm:p-6 md:p-8 lg:p-12 text-white">
                        <div class="space-y-3 sm:space-y-4 md:space-y-6">
                            <!-- Badge -->
                            <?php if($bannerSettings['shop_for_him']['banner_subtitle']): ?>
                            <div class="inline-block">
                                <span class="bg-white/30 backdrop-blur-md text-white px-3 sm:px-4 md:px-5 py-1.5 sm:py-2 md:py-2.5 rounded-full text-[10px] sm:text-xs md:text-sm font-bold uppercase tracking-widest border border-white/30 shadow-lg">
                                    <?php echo e($bannerSettings['shop_for_him']['banner_subtitle']); ?>

                                </span>
                            </div>
                            <?php endif; ?>
                            
                            <!-- Title with Better Typography -->
                            <?php if($bannerSettings['shop_for_him']['banner_title']): ?>
                            <div class="space-y-1 sm:space-y-2 md:space-y-3">
                                <h3 class="text-3xl sm:text-4xl md:text-5xl lg:text-6xl xl:text-7xl 2xl:text-8xl font-black leading-[0.9] tracking-tight">
                                    <span class="block text-white drop-shadow-2xl">SHOP</span>
                                    <span class="block text-white drop-shadow-2xl">FOR</span>
                                    <span class="block text-white drop-shadow-2xl">HIM</span>
                                </h3>
                            </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="space-y-3 sm:space-y-4 md:space-y-6">
                            <!-- Description -->
                            <?php if($bannerSettings['shop_for_him']['banner_description']): ?>
                            <p class="text-white/95 text-sm sm:text-base md:text-lg max-w-md leading-relaxed font-medium drop-shadow-lg">
                                <?php echo e($bannerSettings['shop_for_him']['banner_description']); ?>

                            </p>
                            <?php endif; ?>
                            
                            <!-- CTA Button -->
                            <a href="<?php echo e($bannerSettings['shop_for_him']['banner_link'] ?? route('products.index', ['category' => $categories->where('name', 'like', '%men%')->first()->id ?? ''])); ?>" 
                               class="inline-flex items-center gap-2 sm:gap-3 bg-white text-gray-900 px-4 sm:px-6 md:px-8 py-2.5 sm:py-3 md:py-4 rounded-lg sm:rounded-xl font-bold text-sm sm:text-base md:text-lg hover:bg-gray-50 transition-all duration-300 shadow-xl sm:shadow-2xl hover:shadow-white/50 transform hover:scale-105 group/btn">
                                <span>DISCOVER NOW</span>
                                <svg class="w-4 h-4 sm:w-5 sm:h-5 md:w-6 md:h-6 transition-transform duration-300 group-hover/btn:translate-x-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<script>
let currentHeroSlide = 0;
const totalHeroSlides = <?php echo e($sliders->count() ?? 0); ?>;
let heroSlideInterval;

function changeHeroSlide(direction) {
    const slides = document.querySelectorAll('.hero-slide');
    
    // Remove active class from current slide (this resets the animation)
    slides[currentHeroSlide].classList.remove('active');
    
    // Calculate new slide index
    if (direction === undefined) {
        // Auto-advance
        currentHeroSlide = (currentHeroSlide + 1) % totalHeroSlides;
    } else {
        // Manual navigation
        currentHeroSlide += direction;
        
        // Loop around
        if (currentHeroSlide < 0) {
            currentHeroSlide = totalHeroSlides - 1;
        } else if (currentHeroSlide >= totalHeroSlides) {
            currentHeroSlide = 0;
        }
    }
    
    // Small delay to ensure animation resets, then add active class (this triggers the slide-in animation)
    setTimeout(() => {
        slides[currentHeroSlide].classList.add('active');
    }, 50);
    
    // Reset auto-play timer
    clearInterval(heroSlideInterval);
    startAutoPlay();
}

function startAutoPlay() {
    heroSlideInterval = setInterval(() => {
        changeHeroSlide();
    }, 5000); // Change slide every 5 seconds
}

// Start auto-play when page loads
document.addEventListener('DOMContentLoaded', function() {
    startAutoPlay();
});

function scrollCarousel(carouselId, direction) {
    const carousel = document.getElementById(carouselId + '-carousel');
    if (!carousel) return;
    
    // Calculate scroll amount based on carousel type
    let scrollAmount = 300; // Default
    if (carouselId === 'featured') {
        scrollAmount = 340; // Width of featured product card + gap
    }
    
    carousel.scrollBy({
        left: direction * scrollAmount,
        behavior: 'smooth'
    });
}

// Wishlist functionality
function addToWishlist(form, productId) {
    const formData = new FormData(form);
    const url = form.action;
    const method = form.querySelector('input[name="_method"]')?.value || 'POST';
    
    fetch(url, {
        method: method,
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Update button state
            const button = form.querySelector('button');
            const svg = button.querySelector('svg');
            if (data.added) {
                button.classList.add('text-primary');
                svg.setAttribute('fill', 'currentColor');
                // Update form action for removal
                form.action = '/wishlist/' + productId;
                if (!form.querySelector('input[name="_method"]')) {
                    const methodInput = document.createElement('input');
                    methodInput.type = 'hidden';
                    methodInput.name = '_method';
                    methodInput.value = 'DELETE';
                    form.appendChild(methodInput);
                } else {
                    form.querySelector('input[name="_method"]').value = 'DELETE';
                }
            } else {
                button.classList.remove('text-primary');
                svg.setAttribute('fill', 'none');
                // Update form action for addition
                form.action = '/wishlist/' + productId;
                const methodInput = form.querySelector('input[name="_method"]');
                if (methodInput) {
                    methodInput.remove();
                }
            }
        }
    })
    .catch(error => {
        console.error('Wishlist error:', error);
    });
}

</script>
<!-- Top 8 Popular Product Categories -->
<?php if(isset($topCategorySections) && $topCategorySections->count()): ?>
    <?php $__currentLoopData = $topCategorySections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($section->products->count()): ?>
        <section class="bg-gray-100 py-4 mb-4">
            <div class="container mx-auto px-2 md:px-4">
                <div class="bg-white rounded shadow-sm overflow-hidden">
                    <!-- Header for each category -->
                    <div class="px-4 py-3 flex justify-between items-center" style="background-color: <?php echo e($primaryColor ?? '#ff5349'); ?>;">
                        <h3 class="text-white font-bold text-lg md:text-xl uppercase"><?php echo e($section->category->name); ?></h3>
                        <a href="<?php echo e(route('products.index', ['category' => $section->category->id])); ?>" class="text-white text-sm font-medium hover:underline flex items-center gap-1">
                            See All 
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
                        </a>
                    </div>
                    <!-- Products Grid -->
                    <div class="p-2 md:p-4">
                        <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-6 gap-2 md:gap-4">
                            <?php $__currentLoopData = $section->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="group relative bg-white hover:shadow-lg transition-shadow duration-300 rounded-md p-2 border border-transparent hover:border-gray-200">
                                <a href="<?php echo e(route('products.show', $product->slug)); ?>" class="block h-full pb-10">
                                    <!-- Image -->
                                    <div class="relative aspect-[3/4] mb-2 overflow-hidden rounded bg-gray-100">
                                        <img src="<?php echo e(productImageUrl($product->image)); ?>" alt="<?php echo e($product->name); ?>" class="w-full h-full object-cover group-hover:scale-105 transition duration-300">
                                        <?php if($product->compare_price): ?>
                                            <span class="absolute top-1 right-1 bg-red-100 text-red-600 text-[10px] font-bold px-1.5 py-0.5 rounded">
                                                -<?php echo e(round((($product->compare_price - $product->price) / $product->compare_price) * 100)); ?>%
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    <!-- Details -->
                                    <div class="space-y-1">
                                        <h4 class="text-xs md:text-sm text-gray-700 line-clamp-2 min-h-[2.5em]" title="<?php echo e($product->name); ?>"><?php echo e($product->name); ?></h4>
                                        <div class="flex flex-col">
                                            <span class="text-sm md:text-base font-bold text-gray-900"><?php echo e(currency($product->price)); ?></span>
                                            <?php if($product->compare_price): ?>
                                                <span class="text-xs text-gray-400 line-through"><?php echo e(currency($product->compare_price)); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </a>
                                <!-- Add to Cart -->
                                <div class="absolute bottom-2 left-2 right-2 opacity-100 md:opacity-0 md:group-hover:opacity-100 transition-opacity duration-200">
                                    <form action="<?php echo e(route('cart.store')); ?>" method="POST" class="add-to-cart-form" onclick="event.stopPropagation();">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                        <input type="hidden" name="quantity" value="1">
                                        <button type="submit" class="w-full text-white text-xs md:text-sm font-bold py-1.5 rounded hover:bg-opacity-90 transition shadow-sm uppercase tracking-wide" style="background-color: <?php echo e($primaryColor ?? '#ff5349'); ?>;">
                                            Add To Cart
                                        </button>
                                    </form>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\TrendzTrade\resources\views/home.blade.php ENDPATH**/ ?>