

<?php $__env->startSection('title', 'Create Popup - Admin'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-8 flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-gray-900">Create New Popup</h1>
            <p class="text-gray-600 mt-1">Create a popup that appears on your website</p>
        </div>
        <a href="<?php echo e(route('admin.popups.index')); ?>" class="flex items-center text-gray-600 hover:text-primary transition">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
            </svg>
            Back to Popups
        </a>
    </div>

    <?php if($errors->any()): ?>
        <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6 rounded" role="alert">
            <ul class="list-disc list-inside">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('admin.popups.store')); ?>" method="POST" enctype="multipart/form-data" class="bg-white shadow-lg rounded-xl overflow-hidden">
        <?php echo csrf_field(); ?>
        
        <div class="p-8 space-y-8">
            <!-- Basic Information -->
            <div class="border-b border-gray-200 pb-8">
                <h2 class="text-xl font-semibold text-gray-900 mb-6">Basic Information</h2>
                
                <div class="space-y-6">
                    <div>
                        <label for="title" class="block text-sm font-semibold text-gray-700 mb-2">
                            Title <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="title" id="title" value="<?php echo e(old('title')); ?>" required
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
                    </div>

                    <div>
                        <label for="content" class="block text-sm font-semibold text-gray-700 mb-2">
                            Content
                        </label>
                        <textarea name="content" id="content" rows="4"
                                  class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent resize-none"><?php echo e(old('content')); ?></textarea>
                        <p class="mt-2 text-sm text-gray-500">HTML is allowed</p>
                    </div>

                    <div>
                        <label for="image" class="block text-sm font-semibold text-gray-700 mb-2">
                            Image
                        </label>
                        <input type="file" name="image" id="image" accept="image/*"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
                    </div>
                </div>
            </div>

            <!-- Popup Type & Position -->
            <div class="border-b border-gray-200 pb-8">
                <h2 class="text-xl font-semibold text-gray-900 mb-6">Type & Position</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="type" class="block text-sm font-semibold text-gray-700 mb-2">
                            Popup Type <span class="text-red-500">*</span>
                        </label>
                        <select name="type" id="type" required
                                class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
                            <option value="modal" <?php echo e(old('type') == 'modal' ? 'selected' : ''); ?>>Modal (Center)</option>
                            <option value="slide-in" <?php echo e(old('type') == 'slide-in' ? 'selected' : ''); ?>>Slide-in</option>
                            <option value="banner" <?php echo e(old('type') == 'banner' ? 'selected' : ''); ?>>Banner</option>
                            <option value="notification" <?php echo e(old('type') == 'notification' ? 'selected' : ''); ?>>Notification</option>
                        </select>
                    </div>

                    <div>
                        <label for="position" class="block text-sm font-semibold text-gray-700 mb-2">
                            Position <span class="text-red-500">*</span>
                        </label>
                        <select name="position" id="position" required
                                class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
                            <option value="center" <?php echo e(old('position') == 'center' ? 'selected' : ''); ?>>Center</option>
                            <option value="top" <?php echo e(old('position') == 'top' ? 'selected' : ''); ?>>Top</option>
                            <option value="bottom" <?php echo e(old('position') == 'bottom' ? 'selected' : ''); ?>>Bottom</option>
                            <option value="top-left" <?php echo e(old('position') == 'top-left' ? 'selected' : ''); ?>>Top Left</option>
                            <option value="top-right" <?php echo e(old('position') == 'top-right' ? 'selected' : ''); ?>>Top Right</option>
                            <option value="bottom-left" <?php echo e(old('position') == 'bottom-left' ? 'selected' : ''); ?>>Bottom Left</option>
                            <option value="bottom-right" <?php echo e(old('position') == 'bottom-right' ? 'selected' : ''); ?>>Bottom Right</option>
                        </select>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-6">
                    <div>
                        <label for="width" class="block text-sm font-semibold text-gray-700 mb-2">
                            Width (px or %)
                        </label>
                        <input type="number" name="width" id="width" value="<?php echo e(old('width')); ?>" min="0"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
                    </div>

                    <div>
                        <label for="height" class="block text-sm font-semibold text-gray-700 mb-2">
                            Height (px)
                        </label>
                        <input type="number" name="height" id="height" value="<?php echo e(old('height')); ?>" min="0"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
                    </div>
                </div>

                <div class="mt-6">
                    <label for="animation" class="block text-sm font-semibold text-gray-700 mb-2">
                        Animation
                    </label>
                    <select name="animation" id="animation"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
                        <option value="fade" <?php echo e(old('animation', 'fade') == 'fade' ? 'selected' : ''); ?>>Fade</option>
                        <option value="slide" <?php echo e(old('animation') == 'slide' ? 'selected' : ''); ?>>Slide</option>
                        <option value="zoom" <?php echo e(old('animation') == 'zoom' ? 'selected' : ''); ?>>Zoom</option>
                        <option value="bounce" <?php echo e(old('animation') == 'bounce' ? 'selected' : ''); ?>>Bounce</option>
                    </select>
                </div>
            </div>

            <!-- Target Audience -->
            <div class="border-b border-gray-200 pb-8">
                <h2 class="text-xl font-semibold text-gray-900 mb-6">Target Audience</h2>
                
                <div class="space-y-6">
                    <div>
                        <label for="target_audience" class="block text-sm font-semibold text-gray-700 mb-2">
                            Who Should See This? <span class="text-red-500">*</span>
                        </label>
                        <select name="target_audience" id="target_audience" required
                                class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
                            <option value="all" <?php echo e(old('target_audience') == 'all' ? 'selected' : ''); ?>>All Visitors</option>
                            <option value="guests" <?php echo e(old('target_audience') == 'guests' ? 'selected' : ''); ?>>Guests Only (Not Logged In)</option>
                            <option value="authenticated" <?php echo e(old('target_audience') == 'authenticated' ? 'selected' : ''); ?>>Authenticated Users Only</option>
                            <option value="specific_roles" <?php echo e(old('target_audience') == 'specific_roles' ? 'selected' : ''); ?>>Specific Roles</option>
                        </select>
                    </div>

                    <div id="target_roles_container" style="display: <?php echo e(old('target_audience') == 'specific_roles' ? 'block' : 'none'); ?>;">
                        <label class="block text-sm font-semibold text-gray-700 mb-2">
                            Select Roles
                        </label>
                        <div class="space-y-2">
                            <label class="flex items-center">
                                <input type="checkbox" name="target_roles[]" value="admin" <?php echo e(in_array('admin', old('target_roles', [])) ? 'checked' : ''); ?>

                                       class="rounded border-gray-300 text-primary focus:ring-primary">
                                <span class="ml-2 text-sm text-gray-700">Admin</span>
                            </label>
                            <label class="flex items-center">
                                <input type="checkbox" name="target_roles[]" value="store_owner" <?php echo e(in_array('store_owner', old('target_roles', [])) ? 'checked' : ''); ?>

                                       class="rounded border-gray-300 text-primary focus:ring-primary">
                                <span class="ml-2 text-sm text-gray-700">Store Owner</span>
                            </label>
                            <label class="flex items-center">
                                <input type="checkbox" name="target_roles[]" value="customer" <?php echo e(in_array('customer', old('target_roles', [])) ? 'checked' : ''); ?>

                                       class="rounded border-gray-300 text-primary focus:ring-primary">
                                <span class="ml-2 text-sm text-gray-700">Customer</span>
                            </label>
                        </div>
                    </div>

                    <div>
                        <label for="target_pages" class="block text-sm font-semibold text-gray-700 mb-2">
                            Target Pages (Optional - leave empty for all pages)
                        </label>
                        <input type="text" name="target_pages" id="target_pages" value="<?php echo e(old('target_pages')); ?>"
                               placeholder="e.g., home,products.index,products.show (comma-separated)"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
                        <p class="mt-2 text-sm text-gray-500">Enter route names separated by commas</p>
                    </div>
                </div>
            </div>

            <!-- Display Settings -->
            <div class="border-b border-gray-200 pb-8">
                <h2 class="text-xl font-semibold text-gray-900 mb-6">Display Settings</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="delay_seconds" class="block text-sm font-semibold text-gray-700 mb-2">
                            Delay Before Showing (seconds)
                        </label>
                        <input type="number" name="delay_seconds" id="delay_seconds" value="<?php echo e(old('delay_seconds', 0)); ?>" min="0"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
                    </div>

                    <div>
                        <label for="display_duration" class="block text-sm font-semibold text-gray-700 mb-2">
                            Auto-close After (seconds, leave empty for manual close)
                        </label>
                        <input type="number" name="display_duration" id="display_duration" value="<?php echo e(old('display_duration')); ?>" min="0"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
                    </div>

                    <div>
                        <label for="max_display_count" class="block text-sm font-semibold text-gray-700 mb-2">
                            Max Times to Show Per User
                        </label>
                        <input type="number" name="max_display_count" id="max_display_count" value="<?php echo e(old('max_display_count')); ?>" min="1"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
                    </div>

                    <div>
                        <label for="priority" class="block text-sm font-semibold text-gray-700 mb-2">
                            Priority (higher = shown first)
                        </label>
                        <input type="number" name="priority" id="priority" value="<?php echo e(old('priority', 0)); ?>" min="0"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
                    </div>
                </div>

                <div class="mt-6 space-y-4">
                    <label class="flex items-center">
                        <input type="checkbox" name="show_close_button" value="1" <?php echo e(old('show_close_button', true) ? 'checked' : ''); ?>

                               class="rounded border-gray-300 text-primary focus:ring-primary">
                        <span class="ml-2 text-sm text-gray-700">Show Close Button</span>
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" name="close_on_backdrop" value="1" <?php echo e(old('close_on_backdrop', true) ? 'checked' : ''); ?>

                               class="rounded border-gray-300 text-primary focus:ring-primary">
                        <span class="ml-2 text-sm text-gray-700">Close When Clicking Outside</span>
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" name="is_active" value="1" <?php echo e(old('is_active', true) ? 'checked' : ''); ?>

                               class="rounded border-gray-300 text-primary focus:ring-primary">
                        <span class="ml-2 text-sm text-gray-700">Active</span>
                    </label>
                </div>
            </div>

            <!-- Date Range -->
            <div class="border-b border-gray-200 pb-8">
                <h2 class="text-xl font-semibold text-gray-900 mb-6">Schedule (Optional)</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="start_date" class="block text-sm font-semibold text-gray-700 mb-2">
                            Start Date
                        </label>
                        <input type="datetime-local" name="start_date" id="start_date" value="<?php echo e(old('start_date')); ?>"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
                    </div>

                    <div>
                        <label for="end_date" class="block text-sm font-semibold text-gray-700 mb-2">
                            End Date
                        </label>
                        <input type="datetime-local" name="end_date" id="end_date" value="<?php echo e(old('end_date')); ?>"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
                    </div>
                </div>
            </div>

            <!-- Styling -->
            <div class="border-b border-gray-200 pb-8">
                <h2 class="text-xl font-semibold text-gray-900 mb-6">Styling</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div>
                        <label for="background_color" class="block text-sm font-semibold text-gray-700 mb-2">
                            Background Color (hex)
                        </label>
                        <input type="color" name="background_color" id="background_color" value="<?php echo e(old('background_color', '#ffffff')); ?>"
                               class="w-full h-12 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
                    </div>

                    <div>
                        <label for="text_color" class="block text-sm font-semibold text-gray-700 mb-2">
                            Text Color (hex)
                        </label>
                        <input type="color" name="text_color" id="text_color" value="<?php echo e(old('text_color', '#000000')); ?>"
                               class="w-full h-12 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
                    </div>

                    <div>
                        <label for="button_color" class="block text-sm font-semibold text-gray-700 mb-2">
                            Button Color (hex)
                        </label>
                        <input type="color" name="button_color" id="button_color" value="<?php echo e(old('button_color', '#ff5349')); ?>"
                               class="w-full h-12 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
                    </div>
                </div>
            </div>

            <!-- Call to Action -->
            <div>
                <h2 class="text-xl font-semibold text-gray-900 mb-6">Call to Action Button</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="button_text" class="block text-sm font-semibold text-gray-700 mb-2">
                            Button Text
                        </label>
                        <input type="text" name="button_text" id="button_text" value="<?php echo e(old('button_text')); ?>"
                               placeholder="e.g., Shop Now"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
                    </div>

                    <div>
                        <label for="button_link" class="block text-sm font-semibold text-gray-700 mb-2">
                            Button Link
                        </label>
                        <input type="text" name="button_link" id="button_link" value="<?php echo e(old('button_link')); ?>"
                               placeholder="e.g., /products or https://example.com"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent">
                    </div>
                </div>
            </div>
        </div>

        <div class="px-8 py-6 bg-gray-50 border-t border-gray-200 flex justify-end space-x-4">
            <a href="<?php echo e(route('admin.popups.index')); ?>" class="px-6 py-2 border-2 border-gray-300 text-gray-700 rounded-lg hover:bg-gray-100 transition">
                Cancel
            </a>
            <button type="submit" class="px-6 py-2 bg-primary text-white rounded-lg hover:bg-primary-dark transition">
                Create Popup
            </button>
        </div>
    </form>
</div>

<script>
document.getElementById('target_audience').addEventListener('change', function() {
    const container = document.getElementById('target_roles_container');
    if (this.value === 'specific_roles') {
        container.style.display = 'block';
    } else {
        container.style.display = 'none';
    }
});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\TrendzTrade\resources\views/admin/popups/create.blade.php ENDPATH**/ ?>