<?php $__env->startSection('title', 'Orders'); ?>

<?php $__env->startSection('store-content'); ?>
<div class="space-y-6">
    <!-- Header -->
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <div>
            <h1 class="text-3xl font-bold text-gray-900">Orders</h1>
            <p class="text-gray-600 mt-1">Manage and track your orders</p>
        </div>
    </div>

    <?php if($orders->count() > 0): ?>
        <!-- Orders List -->
        <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Order</th>
                            <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Customer</th>
                            <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Items</th>
                            <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Total</th>
                            <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Status</th>
                            <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Date</th>
                            <th scope="col" class="px-6 py-4 text-right text-xs font-semibold text-gray-700 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="hover:bg-gray-50 transition">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div>
                                        <p class="text-sm font-semibold text-gray-900">#<?php echo e($order->order_number); ?></p>
                                        <p class="text-xs text-gray-500">ID: <?php echo e($order->id); ?></p>
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <div>
                                        <p class="text-sm font-medium text-gray-900">
                                            <?php echo e($order->user ? $order->user->name : $order->shipping_name); ?>

                                        </p>
                                        <?php if($order->user): ?>
                                            <p class="text-xs text-gray-500"><?php echo e($order->user->email); ?></p>
                                        <?php else: ?>
                                            <p class="text-xs text-gray-500"><?php echo e($order->shipping_email ?? 'Guest'); ?></p>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center gap-2">
                                        <span class="text-sm font-medium text-gray-900"><?php echo e($order->items->count()); ?></span>
                                        <span class="text-xs text-gray-500">items</span>
                                    </div>
                                    <?php if($order->items->count() > 0): ?>
                                        <p class="text-xs text-gray-500 mt-1">
                                            <?php echo e($order->items->first()->product->name ?? 'N/A'); ?>

                                            <?php if($order->items->count() > 1): ?>
                                                +<?php echo e($order->items->count() - 1); ?> more
                                            <?php endif; ?>
                                        </p>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <p class="text-sm font-bold text-gray-900"><?php echo e(currency($order->total)); ?></p>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <?php
                                        $statusColors = [
                                            'pending' => 'bg-yellow-100 text-yellow-800',
                                            'processing' => 'bg-blue-100 text-blue-800',
                                            'completed' => 'bg-green-100 text-green-800',
                                            'cancelled' => 'bg-red-100 text-red-800',
                                            'shipped' => 'bg-indigo-100 text-indigo-800',
                                        ];
                                        $statusColor = $statusColors[$order->status] ?? 'bg-gray-100 text-gray-800';
                                    ?>
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium <?php echo e($statusColor); ?>">
                                        <span class="w-2 h-2 rounded-full mr-2 
                                            <?php echo e($order->status === 'completed' ? 'bg-green-500' : 
                                               ($order->status === 'pending' ? 'bg-yellow-500' : 
                                               ($order->status === 'processing' ? 'bg-blue-500' : 'bg-gray-500'))); ?>">
                                        </span>
                                        <?php echo e(ucfirst($order->status)); ?>

                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div>
                                        <p class="text-sm text-gray-900"><?php echo e($order->created_at->format('M d, Y')); ?></p>
                                        <p class="text-xs text-gray-500"><?php echo e($order->created_at->format('h:i A')); ?></p>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                    <button onclick="viewOrder(<?php echo e($order->id); ?>)" 
                                            class="text-primary hover:text-primary-dark font-medium">
                                        View Details
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Pagination -->
        <div class="flex justify-center">
            <?php echo e($orders->links()); ?>

        </div>

        <!-- Order Details Modal -->
        <div id="orderModal" class="hidden fixed inset-0 bg-black bg-opacity-50 z-50 flex items-center justify-center p-4">
            <div class="bg-white rounded-xl shadow-2xl max-w-4xl w-full max-h-[90vh] overflow-y-auto">
                <div class="p-6 border-b border-gray-200 flex items-center justify-between">
                    <h3 class="text-2xl font-bold text-gray-900">Order Details</h3>
                    <button onclick="closeOrderModal()" class="text-gray-400 hover:text-gray-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>
                <div id="orderModalContent" class="p-6">
                    <!-- Order details will be loaded here -->
                </div>
            </div>
        </div>
    <?php else: ?>
        <!-- Empty State -->
        <div class="bg-white rounded-xl shadow-lg border border-gray-100 p-12 text-center">
            <div class="max-w-md mx-auto">
                <svg class="w-24 h-24 text-gray-300 mx-auto mb-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"/>
                </svg>
                <h3 class="text-xl font-bold text-gray-900 mb-2">No orders yet</h3>
                <p class="text-gray-600">Orders from customers will appear here once you start receiving them.</p>
            </div>
        </div>
    <?php endif; ?>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function viewOrder(orderId) {
    // This would typically fetch order details via AJAX
    // For now, just show a message
    document.getElementById('orderModalContent').innerHTML = `
        <div class="text-center py-8">
            <p class="text-gray-600">Order details for order #${orderId}</p>
            <p class="text-sm text-gray-500 mt-2">Detailed view coming soon...</p>
        </div>
    `;
    document.getElementById('orderModal').classList.remove('hidden');
}

function closeOrderModal() {
    document.getElementById('orderModal').classList.add('hidden');
}

// Close modal on outside click
document.getElementById('orderModal')?.addEventListener('click', function(e) {
    if (e.target === this) {
        closeOrderModal();
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('store.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\TrendzTrade\resources\views/store/orders/index.blade.php ENDPATH**/ ?>