<?php $__env->startSection('title', 'Site Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 py-6 sm:py-8">
    <div class="mb-6 sm:mb-8">
        <h1 class="text-2xl sm:text-3xl font-bold text-gray-900">Site Settings</h1>
        <p class="text-gray-600 mt-2 text-sm sm:text-base">Manage your site's appearance and social media links</p>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6 rounded" role="alert">
            <p><?php echo e(session('success')); ?></p>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST" enctype="multipart/form-data" class="bg-white shadow-lg rounded-xl overflow-hidden">
        <?php echo csrf_field(); ?>
        <?php echo method_field('POST'); ?>
        
        <?php if($errors->any()): ?>
            <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 m-6 rounded" role="alert">
                <ul class="list-disc list-inside">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <div class="p-4 sm:p-6 lg:p-8 space-y-6 sm:space-y-8">
            <!-- Site Identity Section -->
            <div class="border-b border-gray-200 pb-6 sm:pb-8">
                <h2 class="text-lg sm:text-xl font-semibold text-gray-900 mb-4 sm:mb-6 flex items-center">
                    <svg class="w-5 h-5 mr-2 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21a4 4 0 01-4-4V5a2 2 0 012-2h4a2 2 0 012 2v12a4 4 0 01-4 4zm0 0h12a2 2 0 002-2v-4a2 2 0 00-2-2h-2.343M11 7.343l1.657-1.657a2 2 0 012.828 0l2.829 2.829a2 2 0 010 2.828l-8.486 8.485M7 17h.01"/>
                    </svg>
                    Site Identity
                </h2>
                
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                    <!-- Site Title -->
                <div>
                    <label for="site_title" class="block text-sm font-semibold text-gray-700 mb-2">
                        Site Title <span class="text-red-500">*</span>
                    </label>
                    <input type="text" name="site_title" id="site_title" value="<?php echo e(old('site_title', $settings['site_title'])); ?>" required
                           placeholder="e.g., Vibrant Vogue"
                           class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition">
                        <p class="mt-2 text-xs sm:text-sm text-gray-500">
                        This will appear in the browser tab and as the default page title.
                    </p>
                    <?php $__errorArgs = ['site_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Primary Color -->
                    <div>
                        <label for="primary_color" class="block text-sm font-semibold text-gray-700 mb-2">
                            Primary Color <span class="text-red-500">*</span>
                        </label>
                        <div class="flex items-center gap-3">
                            <input type="color" name="primary_color" id="primary_color" value="<?php echo e(old('primary_color', $settings['primary_color'])); ?>" required
                                   class="w-16 h-16 sm:w-20 sm:h-20 border-2 border-gray-200 rounded-lg cursor-pointer focus:outline-none focus:ring-2 focus:ring-primary">
                            <input type="text" name="primary_color_text" id="primary_color_text" value="<?php echo e(old('primary_color', $settings['primary_color'])); ?>" 
                                   pattern="^#[0-9A-Fa-f]{6}$"
                                   placeholder="#ff5349"
                                   class="flex-1 px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition"
                                   onchange="document.getElementById('primary_color').value = this.value;">
                        </div>
                        <p class="mt-2 text-xs sm:text-sm text-gray-500">
                            This color will be used throughout the site for buttons, links, and accents.
                        </p>
                        <?php $__errorArgs = ['primary_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <!-- Logo & Favicon Section -->
            <div class="border-b border-gray-200 pb-6 sm:pb-8">
                <h2 class="text-lg sm:text-xl font-semibold text-gray-900 mb-4 sm:mb-6 flex items-center">
                    <svg class="w-5 h-5 mr-2 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                    </svg>
                    Logo & Favicon
                </h2>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Site Logo -->
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">Site Logo</label>
                
                <?php if($settings['site_logo']): ?>
                    <div class="mb-4">
                                <p class="text-xs sm:text-sm text-gray-600 mb-2">Current Logo:</p>
                        <img src="<?php echo e(productImageUrl($settings['site_logo'])); ?>" 
                             alt="Current site logo" 
                                     class="max-w-xs h-16 sm:h-20 object-contain rounded-lg border-2 border-gray-200"
                             onerror="this.src='<?php echo e(url('images/placeholder.jpg')); ?>'; this.onerror=null;">
                    </div>
                <?php endif; ?>

                        <div class="mt-1 flex justify-center px-4 sm:px-6 pt-4 sm:pt-5 pb-4 sm:pb-6 border-2 border-gray-300 border-dashed rounded-lg hover:border-primary transition cursor-pointer" onclick="document.getElementById('site_logo').click()">
                        <div class="space-y-1 text-center">
                                <svg class="mx-auto h-10 w-10 sm:h-12 sm:w-12 text-gray-400" stroke="currentColor" fill="none" viewBox="0 0 48 48">
                                <path d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                                <div class="flex text-xs sm:text-sm text-gray-600 justify-center">
                                <label for="site_logo" class="relative cursor-pointer rounded-md font-medium text-primary hover:text-primary-dark">
                                    <span>Upload a file</span>
                                    <input id="site_logo" name="site_logo" type="file" class="sr-only" accept="image/*" onchange="previewLogo(this)">
                                </label>
                                <p class="pl-1">or drag and drop</p>
                            </div>
                            <p class="text-xs text-gray-500">PNG, JPG, GIF, WEBP, SVG up to 5MB</p>
                        </div>
                    </div>
                    <div id="logo-preview" class="mt-4 hidden">
                            <p class="text-xs sm:text-sm text-gray-600 mb-2">New Logo Preview:</p>
                            <img id="logo-preview-img" src="" alt="Preview" class="max-w-xs h-16 sm:h-20 object-contain rounded-lg border-2 border-gray-200">
                            <button type="button" onclick="removeLogo()" class="mt-2 text-xs sm:text-sm text-red-600 hover:text-red-800">Remove new logo</button>
                    </div>
                    <?php $__errorArgs = ['site_logo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

                    <!-- Favicon -->
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">Favicon</label>
                
                <?php if($settings['site_favicon']): ?>
                    <div class="mb-4">
                                <p class="text-xs sm:text-sm text-gray-600 mb-2">Current Favicon:</p>
                        <img src="<?php echo e(productImageUrl($settings['site_favicon'])); ?>" 
                             alt="Current favicon" 
                                     class="w-12 h-12 sm:w-16 sm:h-16 object-contain rounded-lg border-2 border-gray-200"
                             onerror="this.src='<?php echo e(url('images/placeholder.jpg')); ?>'; this.onerror=null;">
                    </div>
                <?php endif; ?>

                        <div class="mt-1 flex justify-center px-4 sm:px-6 pt-4 sm:pt-5 pb-4 sm:pb-6 border-2 border-gray-300 border-dashed rounded-lg hover:border-primary transition cursor-pointer" onclick="document.getElementById('site_favicon').click()">
                        <div class="space-y-1 text-center">
                                <svg class="mx-auto h-10 w-10 sm:h-12 sm:w-12 text-gray-400" stroke="currentColor" fill="none" viewBox="0 0 48 48">
                                <path d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                                <div class="flex text-xs sm:text-sm text-gray-600 justify-center">
                                <label for="site_favicon" class="relative cursor-pointer rounded-md font-medium text-primary hover:text-primary-dark">
                                    <span>Upload a file</span>
                                    <input id="site_favicon" name="site_favicon" type="file" class="sr-only" accept="image/*,.ico" onchange="previewFavicon(this)">
                                </label>
                                <p class="pl-1">or drag and drop</p>
                            </div>
                            <p class="text-xs text-gray-500">ICO, PNG, JPG up to 1MB (Recommended: 32x32 or 16x16)</p>
                        </div>
                    </div>
                    <div id="favicon-preview" class="mt-4 hidden">
                            <p class="text-xs sm:text-sm text-gray-600 mb-2">New Favicon Preview:</p>
                            <img id="favicon-preview-img" src="" alt="Preview" class="w-12 h-12 sm:w-16 sm:h-16 object-contain rounded-lg border-2 border-gray-200">
                            <button type="button" onclick="removeFavicon()" class="mt-2 text-xs sm:text-sm text-red-600 hover:text-red-800">Remove new favicon</button>
                    </div>
                    <?php $__errorArgs = ['site_favicon'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
        </div>

            <!-- Social Media Section -->
            <div class="pb-6 sm:pb-8">
                <h2 class="text-lg sm:text-xl font-semibold text-gray-900 mb-4 sm:mb-6 flex items-center">
                    <svg class="w-5 h-5 mr-2 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"/>
                    </svg>
                    Social Media Links
                </h2>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-6">
                    <!-- Facebook -->
                    <div>
                        <label for="facebook_url" class="block text-sm font-semibold text-gray-700 mb-2 flex items-center">
                            <svg class="w-5 h-5 mr-2 text-blue-600" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                            </svg>
                            Facebook URL
                        </label>
                        <input type="url" name="facebook_url" id="facebook_url" value="<?php echo e(old('facebook_url', $settings['facebook_url'])); ?>"
                               placeholder="https://facebook.com/yourpage"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition">
                        <?php $__errorArgs = ['facebook_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- WhatsApp -->
                    <div>
                        <label for="whatsapp_url" class="block text-sm font-semibold text-gray-700 mb-2 flex items-center">
                            <svg class="w-5 h-5 mr-2 text-green-600" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413Z"/>
                            </svg>
                            WhatsApp URL
                        </label>
                        <input type="url" name="whatsapp_url" id="whatsapp_url" value="<?php echo e(old('whatsapp_url', $settings['whatsapp_url'])); ?>"
                               placeholder="https://wa.me/1234567890"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition">
                        <?php $__errorArgs = ['whatsapp_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Instagram -->
                    <div>
                        <label for="instagram_url" class="block text-sm font-semibold text-gray-700 mb-2 flex items-center">
                            <svg class="w-5 h-5 mr-2 text-pink-600" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                            </svg>
                            Instagram URL
                        </label>
                        <input type="url" name="instagram_url" id="instagram_url" value="<?php echo e(old('instagram_url', $settings['instagram_url'])); ?>"
                               placeholder="https://instagram.com/yourhandle"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition">
                        <?php $__errorArgs = ['instagram_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- YouTube -->
                    <div>
                        <label for="youtube_url" class="block text-sm font-semibold text-gray-700 mb-2 flex items-center">
                            <svg class="w-5 h-5 mr-2 text-red-600" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/>
                            </svg>
                            YouTube URL
                        </label>
                        <input type="url" name="youtube_url" id="youtube_url" value="<?php echo e(old('youtube_url', $settings['youtube_url'])); ?>"
                               placeholder="https://youtube.com/@yourchannel"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition">
                        <?php $__errorArgs = ['youtube_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Snapchat -->
                    <div>
                        <label for="snapchat_url" class="block text-sm font-semibold text-gray-700 mb-2 flex items-center">
                            <svg class="w-5 h-5 mr-2 text-yellow-400" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12.166 2c-5.5 0-9.955 4.373-9.955 9.766 0 4.305 2.69 7.98 6.5 9.45-.09-.81-.16-2.08.035-2.84.18-.77 1.15-5.1 1.15-5.1s-.3-.6-.3-1.48c0-1.38.8-2.42 1.8-2.42.85 0 1.26.64 1.26 1.4 0 .85-.54 2.1-.82 3.27-.23 1 .48 1.8 1.48 1.8 1.78 0 3.15-1.87 3.15-4.57 0-2.38-1.72-4.06-4.18-4.06-2.84 0-4.5 2.13-4.5 4.33 0 .86.33 1.78.74 2.28.08.1.09.19.07.29-.07.31-.24 1-.27 1.14-.04.19-.14.23-.33.14-1.24-.58-2.02-2.4-2.02-3.86 0-3.15 2.29-6.05 6.6-6.05 3.46 0 6.16 2.47 6.16 5.76 0 3.44-2.17 6.22-5.19 6.22-1.01 0-1.96-.53-2.29-1.23l-.62 2.38c-.22.87-.82 1.96-1.24 2.62.9.27 1.85.42 2.83.42 5.5 0 9.96-4.37 9.96-9.77C22.126 6.373 17.666 2 12.166 2z"/>
                            </svg>
                            Snapchat URL
                        </label>
                        <input type="url" name="snapchat_url" id="snapchat_url" value="<?php echo e(old('snapchat_url', $settings['snapchat_url'])); ?>"
                               placeholder="https://snapchat.com/add/yourusername"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition">
                        <?php $__errorArgs = ['snapchat_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- TikTok -->
                    <div>
                        <label for="tiktok_url" class="block text-sm font-semibold text-gray-700 mb-2 flex items-center">
                            <svg class="w-5 h-5 mr-2 text-black" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M19.59 6.69a4.83 4.83 0 0 1-3.77-4.25V2h-3.45v13.67a2.89 2.89 0 0 1-5.2 1.74 2.89 2.89 0 0 1 2.31-4.64 2.93 2.93 0 0 1 .88.13V9.4a6.84 6.84 0 0 0-1-.05A6.33 6.33 0 0 0 5 20.1a6.34 6.34 0 0 0 10.86-4.43v-7a8.16 8.16 0 0 0 4.77 1.52v-3.4a4.85 4.85 0 0 1-1-.1z"/>
                            </svg>
                            TikTok URL
                        </label>
                        <input type="url" name="tiktok_url" id="tiktok_url" value="<?php echo e(old('tiktok_url', $settings['tiktok_url'])); ?>"
                               placeholder="https://tiktok.com/@yourhandle"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition">
                        <?php $__errorArgs = ['tiktok_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <!-- Homepage Settings Section -->
            <div class="border-b border-gray-200 pb-6 sm:pb-8">
                <h2 class="text-lg sm:text-xl font-semibold text-gray-900 mb-4 sm:mb-6 flex items-center">
                    <svg class="w-5 h-5 mr-2 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                    </svg>
                    Homepage Settings
                </h2>
                
                <div class="space-y-4">
                    <!-- Show Featured Products Section Toggle -->
                    <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                        <div class="flex-1">
                            <label for="show_featured_products_section" class="block text-sm font-semibold text-gray-900 mb-1">
                                Show Featured Products Section
                            </label>
                            <p class="text-xs sm:text-sm text-gray-600">
                                Toggle to show or hide the featured products grid on the homepage. The promotional image will remain visible.
                            </p>
                        </div>
                        <label class="relative inline-flex items-center cursor-pointer ml-4">
                            <input type="hidden" name="show_featured_products_section" value="0">
                            <input type="checkbox" name="show_featured_products_section" id="show_featured_products_section" value="1" 
                                   <?php echo e(old('show_featured_products_section', $settings['show_featured_products_section']) == '1' ? 'checked' : ''); ?>

                                   class="sr-only peer">
                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary/20 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                        </label>
                    </div>

                    <!-- Show New Arrivals Section Toggle -->
                    <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                        <div class="flex-1">
                            <label for="show_new_arrivals_section" class="block text-sm font-semibold text-gray-900 mb-1">
                                Show New Arrivals Section
                            </label>
                            <p class="text-xs sm:text-sm text-gray-600">
                                Toggle to show or hide the "New Arrivals" section (LATEST FASHION) on the homepage.
                            </p>
                        </div>
                        <label class="relative inline-flex items-center cursor-pointer ml-4">
                            <input type="hidden" name="show_new_arrivals_section" value="0">
                            <input type="checkbox" name="show_new_arrivals_section" id="show_new_arrivals_section" value="1" 
                                   <?php echo e(old('show_new_arrivals_section', $settings['show_new_arrivals_section']) == '1' ? 'checked' : ''); ?>

                                   class="sr-only peer">
                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary/20 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                        </label>
                    </div>
                </div>
            </div>

            <!-- Banner Settings Section -->
            <div class="border-b border-gray-200 pb-6 sm:pb-8">
                <h2 class="text-lg sm:text-xl font-semibold text-gray-900 mb-4 sm:mb-6 flex items-center">
                    <svg class="w-5 h-5 mr-2 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                    </svg>
                    Banner Settings
                </h2>
                
                <div class="space-y-4">
                    <!-- Featured Banner Toggle -->
                    <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                        <div class="flex-1">
                            <label for="featured_banner_active" class="block text-sm font-semibold text-gray-900 mb-1">
                                Featured Banner (Shop Top Picks Section)
                            </label>
                            <p class="text-xs sm:text-sm text-gray-600">
                                Toggle to show or hide the featured banner on the homepage.
                            </p>
                        </div>
                        <label class="relative inline-flex items-center cursor-pointer ml-4">
                            <input type="hidden" name="featured_banner_active" value="0">
                            <input type="checkbox" name="featured_banner_active" id="featured_banner_active" value="1" 
                                   <?php echo e(old('featured_banner_active', $settings['featured_banner_active']) == '1' ? 'checked' : ''); ?>

                                   class="sr-only peer">
                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary/20 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                        </label>
                    </div>

                    <!-- Trending Banner Toggle -->
                    <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                        <div class="flex-1">
                            <label for="trending_banner_active" class="block text-sm font-semibold text-gray-900 mb-1">
                                Trending Banner (Shop Trending Section)
                            </label>
                            <p class="text-xs sm:text-sm text-gray-600">
                                Toggle to show or hide the trending banner on the homepage.
                            </p>
                        </div>
                        <label class="relative inline-flex items-center cursor-pointer ml-4">
                            <input type="hidden" name="trending_banner_active" value="0">
                            <input type="checkbox" name="trending_banner_active" id="trending_banner_active" value="1" 
                                   <?php echo e(old('trending_banner_active', $settings['trending_banner_active']) == '1' ? 'checked' : ''); ?>

                                   class="sr-only peer">
                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary/20 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                        </label>
                    </div>

                    <!-- Shop For Her Banner Toggle -->
                    <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                        <div class="flex-1">
                            <label for="shop_for_her_banner_active" class="block text-sm font-semibold text-gray-900 mb-1">
                                Shop For Her Banner (Left Side)
                            </label>
                            <p class="text-xs sm:text-sm text-gray-600">
                                Toggle to show or hide the "Shop For Her" banner on the homepage.
                            </p>
                        </div>
                        <label class="relative inline-flex items-center cursor-pointer ml-4">
                            <input type="hidden" name="shop_for_her_banner_active" value="0">
                            <input type="checkbox" name="shop_for_her_banner_active" id="shop_for_her_banner_active" value="1" 
                                   <?php echo e(old('shop_for_her_banner_active', $settings['shop_for_her_banner_active']) == '1' ? 'checked' : ''); ?>

                                   class="sr-only peer">
                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary/20 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                        </label>
                    </div>

                    <!-- Shop For Him Banner Toggle -->
                    <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                        <div class="flex-1">
                            <label for="shop_for_him_banner_active" class="block text-sm font-semibold text-gray-900 mb-1">
                                Shop For Him Banner (Right Side)
                            </label>
                            <p class="text-xs sm:text-sm text-gray-600">
                                Toggle to show or hide the "Shop For Him" banner on the homepage.
                            </p>
                        </div>
                        <label class="relative inline-flex items-center cursor-pointer ml-4">
                            <input type="hidden" name="shop_for_him_banner_active" value="0">
                            <input type="checkbox" name="shop_for_him_banner_active" id="shop_for_him_banner_active" value="1" 
                                   <?php echo e(old('shop_for_him_banner_active', $settings['shop_for_him_banner_active']) == '1' ? 'checked' : ''); ?>

                                   class="sr-only peer">
                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary/20 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary"></div>
                        </label>
                    </div>
                </div>
            </div>
        </div>

        <div class="px-4 sm:px-6 lg:px-8 py-4 sm:py-6 bg-gray-50 border-t border-gray-200 flex flex-col sm:flex-row justify-end space-y-2 sm:space-y-0 sm:space-x-4">
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="px-6 py-3 border border-gray-300 rounded-lg text-gray-700 font-semibold hover:bg-gray-100 transition text-center">
                Cancel
            </a>
            <button type="submit" class="px-6 py-3 bg-primary text-white rounded-lg font-semibold hover:bg-primary-dark transition shadow-md hover:shadow-lg text-center">
                Update Settings
            </button>
        </div>
    </form>
</div>

<script>
function previewLogo(input) {
    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = function(e) {
            document.getElementById('logo-preview-img').src = e.target.result;
            document.getElementById('logo-preview').classList.remove('hidden');
        };
        reader.readAsDataURL(input.files[0]);
    }
}

function removeLogo() {
    document.getElementById('site_logo').value = '';
    document.getElementById('logo-preview').classList.add('hidden');
}

function previewFavicon(input) {
    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = function(e) {
            document.getElementById('favicon-preview-img').src = e.target.result;
            document.getElementById('favicon-preview').classList.remove('hidden');
        };
        reader.readAsDataURL(input.files[0]);
    }
}

function removeFavicon() {
    document.getElementById('site_favicon').value = '';
    document.getElementById('favicon-preview').classList.add('hidden');
}

// Sync color picker with text input
document.addEventListener('DOMContentLoaded', function() {
    const colorPicker = document.getElementById('primary_color');
    const colorText = document.getElementById('primary_color_text');
    
    if (colorPicker && colorText) {
        colorPicker.addEventListener('input', function(e) {
            colorText.value = e.target.value;
        });
        
        colorText.addEventListener('input', function(e) {
            if (/^#[0-9A-Fa-f]{6}$/.test(e.target.value)) {
                colorPicker.value = e.target.value;
            }
        });
        
        // Update text input when form is submitted
        document.querySelector('form').addEventListener('submit', function() {
            colorPicker.value = colorText.value;
        });
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\TrendzTrade\resources\views/admin/settings/index.blade.php ENDPATH**/ ?>