

<?php $__env->startSection('title', 'Order Confirmation'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50">
    <!-- Success Hero Section -->
    <section class="text-white py-12 md:py-16" style="background: linear-gradient(135deg, <?php echo e($primaryColor ?? '#ff5349'); ?> 0%, <?php echo e($primaryColor ?? '#ff5349'); ?>dd 100%);">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center max-w-3xl mx-auto">
                <div class="inline-flex items-center justify-center w-20 h-20 bg-white/20 rounded-full mb-6 backdrop-blur-sm">
                    <svg class="w-12 h-12 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                </div>
                <h1 class="text-4xl md:text-5xl lg:text-6xl font-black mb-4 text-white">Thank You!</h1>
                <p class="text-xl md:text-2xl text-white/90 leading-relaxed mb-2">
                    Your order has been received and is being processed
                </p>
                <p class="text-lg text-white/80">
                    Order #<?php echo e($order->order_number); ?>

                </p>
            </div>
        </div>
    </section>

    <!-- Main Content -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8 md:py-12">
        <?php if(session('success')): ?>
            <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6 rounded" role="alert">
                <p><?php echo e(session('success')); ?></p>
            </div>
        <?php endif; ?>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 md:gap-8">
            <!-- Order Items -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Order Items Card -->
                <div class="bg-white rounded-xl shadow-lg p-6 md:p-8">
                    <div class="flex items-center justify-between mb-6">
                        <h2 class="text-2xl md:text-3xl font-bold text-gray-900">Order Items</h2>
                        <span class="text-sm text-gray-600"><?php echo e($order->items->count()); ?> item(s)</span>
                    </div>
                    <div class="space-y-4">
                        <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="flex gap-4 p-4 border-2 border-gray-100 rounded-xl hover:border-primary/30 hover:shadow-md transition-all">
                                <div class="w-24 h-24 md:w-32 md:h-32 bg-gray-100 rounded-lg overflow-hidden flex-shrink-0">
                                    <img src="<?php echo e(productImageUrl($item->product_image)); ?>" alt="<?php echo e($item->product_name); ?>" 
                                         class="w-full h-full object-cover"
                                         onerror="this.onerror=null; this.src='<?php echo e(asset('images/placeholder.jpg')); ?>';">
                                </div>
                                <div class="flex-1 min-w-0">
                                    <h3 class="font-bold text-gray-900 mb-2 text-lg"><?php echo e($item->product_name); ?></h3>
                                    <div class="space-y-1 mb-3">
                                        <?php if($item->size): ?>
                                            <p class="text-gray-600 text-sm">
                                                <span class="font-medium">Size:</span> <?php echo e($item->size); ?>

                                            </p>
                                        <?php endif; ?>
                                        <?php if($item->color): ?>
                                            <p class="text-gray-600 text-sm">
                                                <span class="font-medium">Color:</span> <?php echo e($item->color); ?>

                                            </p>
                                        <?php endif; ?>
                                        <p class="text-gray-600 text-sm">
                                            <span class="font-medium">Quantity:</span> <?php echo e($item->quantity); ?>

                                        </p>
                                    </div>
                                    <div class="flex items-center justify-between mt-4">
                                        <p class="text-primary font-bold text-lg"><?php echo e(currency($item->price)); ?></p>
                                        <p class="text-gray-700 font-semibold">Subtotal: <?php echo e(currency($item->subtotal)); ?></p>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <!-- Shipping Address Card -->
                <div class="bg-white rounded-xl shadow-lg p-6 md:p-8">
                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-6">Shipping Address</h2>
                    <div class="bg-gray-50 rounded-lg p-6 space-y-2">
                        <p class="text-gray-900 font-semibold text-lg"><?php echo e($order->shipping_name); ?></p>
                        <p class="text-gray-700"><?php echo e($order->shipping_address); ?></p>
                        <?php if($order->shipping_city || $order->shipping_state || $order->shipping_postal_code): ?>
                            <p class="text-gray-700">
                                <?php echo e($order->shipping_city); ?><?php echo e($order->shipping_state ? ', ' . $order->shipping_state : ''); ?> <?php echo e($order->shipping_postal_code); ?>

                            </p>
                        <?php endif; ?>
                        <?php if($order->shipping_country): ?>
                            <p class="text-gray-700"><?php echo e($order->shipping_country); ?></p>
                        <?php endif; ?>
                        <div class="pt-3 border-t border-gray-200 mt-3">
                            <p class="text-gray-700">
                                <span class="font-medium">Email:</span> <?php echo e($order->shipping_email); ?>

                            </p>
                            <p class="text-gray-700">
                                <span class="font-medium">Phone:</span> <?php echo e($order->shipping_phone); ?>

                            </p>
                        </div>
                    </div>
                </div>

                <?php if($order->notes): ?>
                    <div class="bg-white rounded-xl shadow-lg p-6 md:p-8">
                        <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">Order Notes</h2>
                        <p class="text-gray-700 bg-gray-50 rounded-lg p-4"><?php echo e($order->notes); ?></p>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Order Summary Sidebar -->
            <div class="lg:col-span-1">
                <div class="bg-white rounded-xl shadow-lg p-6 md:p-8 sticky top-20 space-y-6">
                    <!-- Order Status -->
                    <div>
                        <h2 class="text-xl font-bold text-gray-900 mb-4">Order Status</h2>
                        <div class="space-y-3">
                            <span class="inline-flex items-center px-4 py-2 rounded-full text-sm font-semibold
                                <?php if($order->status == 'pending'): ?> bg-yellow-100 text-yellow-800
                                <?php elseif($order->status == 'processing'): ?> bg-blue-100 text-blue-800
                                <?php elseif($order->status == 'shipped'): ?> bg-purple-100 text-purple-800
                                <?php elseif($order->status == 'completed' || $order->status == 'delivered'): ?> bg-green-100 text-green-800
                                <?php else: ?> bg-red-100 text-red-800
                                <?php endif; ?>">
                                <?php echo e(ucfirst($order->status)); ?>

                            </span>
                            <p class="text-gray-600 text-sm">
                                <span class="font-medium">Payment:</span> 
                                <span class="capitalize"><?php echo e($order->payment_status); ?></span>
                            </p>
                            <p class="text-gray-600 text-sm">
                                <span class="font-medium">Method:</span> 
                                <span class="capitalize"><?php echo e(str_replace('_', ' ', $order->payment_method)); ?></span>
                            </p>
                            <p class="text-gray-500 text-xs pt-2 border-t border-gray-200">
                                Placed on <?php echo e($order->created_at->format('M d, Y h:i A')); ?>

                            </p>
                        </div>
                    </div>

                    <!-- Order Summary -->
                    <div>
                        <h2 class="text-xl font-bold text-gray-900 mb-4">Order Summary</h2>
                        <div class="space-y-3">
                            <div class="flex justify-between text-gray-700">
                                <span>Subtotal</span>
                                <span class="font-medium"><?php echo e(currency($order->subtotal)); ?></span>
                            </div>
                            <div class="flex justify-between text-gray-700">
                                <span>Tax</span>
                                <span class="font-medium"><?php echo e(currency($order->tax)); ?></span>
                            </div>
                            <div class="flex justify-between text-gray-700">
                                <span>Shipping</span>
                                <span class="font-medium"><?php echo e(currency($order->shipping)); ?></span>
                            </div>
                            <div class="border-t-2 border-gray-300 pt-3 mt-3">
                                <div class="flex justify-between text-gray-900 font-bold text-xl">
                                    <span>Total</span>
                                    <span class="text-primary"><?php echo e(currency($order->total)); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="space-y-3 pt-4 border-t border-gray-200">
                        <a href="<?php echo e(route('home')); ?>" 
                           class="w-full bg-primary text-white px-6 py-3 rounded-lg font-bold text-center hover:bg-primary-dark transition shadow-lg hover:shadow-xl block">
                            Continue Shopping
                        </a>
                        <?php if(auth()->guard()->check()): ?>
                            <a href="<?php echo e(route('orders.index')); ?>" 
                               class="w-full bg-gray-100 text-gray-900 px-6 py-3 rounded-lg font-semibold text-center hover:bg-gray-200 transition block">
                                View All Orders
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\TrendzTrade\resources\views/orders/show.blade.php ENDPATH**/ ?>