<?php $__env->startSection('title', 'Manage Stores'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-gray-900">Store Approvals</h1>
        <p class="text-gray-600 mt-2">Manage pending store registrations</p>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6" role="alert">
            <p><?php echo e(session('success')); ?></p>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6" role="alert">
            <p><?php echo e(session('error')); ?></p>
        </div>
    <?php endif; ?>

    <div class="bg-white shadow overflow-hidden sm:rounded-md">
        <ul class="divide-y divide-gray-200">
            <?php $__empty_1 = true; $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <li>
                    <div class="px-4 py-4 sm:px-6 flex items-center justify-between">
                        <div class="flex items-center space-x-4 flex-1">
                            <div class="flex-1 min-w-0">
                                <p class="text-lg font-semibold text-gray-900"><?php echo e($store->business_name); ?></p>
                                <?php if($store->user): ?>
                                <p class="text-sm text-gray-500 mt-1"><?php echo e($store->user->name); ?> - <?php echo e($store->user->email); ?></p>
                                <?php else: ?>
                                <p class="text-sm text-gray-500 mt-1">Owner not found</p>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="flex items-center space-x-2">
                            <form action="<?php echo e(route('admin.manual-approval.approve-store')); ?>" method="POST" class="inline">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="store_id" value="<?php echo e($store->id); ?>">
                                <button type="submit" class="bg-green-500 text-white px-4 py-2 rounded hover:bg-green-600 transition">Approve</button>
                            </form>
                        </div>
                    </div>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <li class="px-4 py-4 sm:px-6">
                    <p class="text-gray-500">No pending store approvals.</p>
                </li>
            <?php endif; ?>
        </ul>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\TrendzTrade\resources\views/admin/stores/index.blade.php ENDPATH**/ ?>