@extends('store.layout')

@section('title', 'Tools')

@section('store-content')
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <h1 class="text-3xl font-bold text-gray-900 mb-6">Tools</h1>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            @foreach ($tools as $tool)
                <div class="bg-white shadow rounded-lg p-6">
                    <h2 class="text-xl font-bold text-gray-900">{{ $tool['name'] }}</h2>
                    <p class="mt-2 text-gray-600">{{ $tool['description'] }}</p>
                    <a href="{{ $tool['url'] }}" class="mt-4 inline-block bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                        Launch Tool
                    </a>
                </div>
            @endforeach
        </div>
    </div>
@endsection
