@extends('store.layout')

@section('title', 'Request Quotes')

@section('store-content')
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <h1 class="text-3xl font-bold text-gray-900 mb-6">Request Quotes</h1>

        @if (session('success'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-6" role="alert">
                <span class="block sm:inline">{{ session('success') }}</span>
            </div>
        @endif

        <div class="bg-white shadow rounded-lg">
            <div class="px-4 py-5 sm:p-6">
                @if ($quotes->isEmpty())
                    <div class="text-center py-12">
                        <p class="text-gray-500 text-lg">You have not received any quotes yet.</p>
                    </div>
                @else
                    <div class="divide-y divide-gray-200">
                        @foreach ($quotes as $quote)
                            <div class="py-6">
                                <div class="flex items-center justify-between">
                                    <div class="text-sm font-medium text-gray-900">
                                        <span class="font-bold">From:</span> {{ $quote->user->name }}
                                    </div>
                                    <div class="text-sm text-gray-500">
                                        {{ $quote->created_at->format('M d, Y') }}
                                    </div>
                                </div>
                                @if ($quote->product)
                                    <div class="mt-2 text-sm text-gray-600">
                                        <span class="font-bold">Product:</span> {{ $quote->product->name }}
                                    </div>
                                @endif
                                <div class="mt-4">
                                    <p class="text-gray-800">{{ $quote->message }}</p>
                                </div>

                                @if ($quote->reply)
                                    <div class="mt-4 bg-gray-50 p-4 rounded-lg">
                                        <h4 class="font-semibold text-gray-800">Your Reply:</h4>
                                        <p class="text-gray-700">{{ $quote->reply }}</p>
                                    </div>
                                @else
                                    <form action="{{ route('store.request-quotes.reply', $quote) }}" method="POST" class="mt-4">
                                        @csrf
                                        <div class="w-full">
                                            <label for="reply-{{ $quote->id }}" class="sr-only">Your Reply</label>
                                            <textarea name="reply" id="reply-{{ $quote->id }}" rows="3" class="shadow-sm focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md" placeholder="Write your reply..."></textarea>
                                        </div>
                                        <div class="mt-3 text-right">
                                            <button type="submit" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                                Send Reply
                                            </button>
                                        </div>
                                    </form>
                                @endif
                            </div>
                        @endforeach
                    </div>

                    <div class="mt-6">
                        {{ $quotes->links() }}
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection
