@extends('layouts.app')

@section('title', 'Terms & Conditions')

@section('content')
<div class="min-h-screen bg-gray-50">
    <!-- Hero Section -->
    <section class="text-white py-16 md:py-24" style="background: linear-gradient(135deg, {{ $primaryColor ?? '#ff5349' }} 0%, {{ $primaryColor ?? '#ff5349' }}dd 100%);">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center max-w-3xl mx-auto">
                <h1 class="text-4xl md:text-5xl lg:text-6xl font-black mb-6 text-white">Terms & Conditions</h1>
                <p class="text-xl md:text-2xl text-white/90 leading-relaxed">
                    Please read these terms carefully before using our website and services.
                </p>
            </div>
        </div>
    </section>

    <!-- Main Content -->
    <section class="py-12 md:py-16">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-white rounded-xl shadow-lg p-8 md:p-12 space-y-8">
                <p class="text-sm text-gray-500 mb-8">
                    Last updated: {{ date('F d, Y') }}
                </p>

                <div class="prose prose-lg max-w-none">
                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">1. Agreement to Terms</h2>
                    <p class="text-gray-700 mb-6 leading-relaxed">
                        By accessing and using {{ $siteTitle ?? 'Vibrant Vogue' }} website, you accept and agree to be bound by 
                        these Terms and Conditions. If you do not agree with any part of these terms, you must not use our website.
                    </p>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">2. Use of Website</h2>
                    <p class="text-gray-700 mb-4 leading-relaxed">
                        You agree to use our website only for lawful purposes and in a way that does not infringe the rights of, 
                        restrict, or inhibit anyone else's use and enjoyment of the website. Prohibited behavior includes:
                    </p>
                    <ul class="list-disc list-inside space-y-2 text-gray-700 ml-4 mb-6">
                        <li>Harassing or causing distress to other users</li>
                        <li>Transmitting obscene or offensive content</li>
                        <li>Disrupting the normal flow of dialogue on our website</li>
                        <li>Attempting to gain unauthorized access to our systems</li>
                        <li>Using automated systems to access the website without permission</li>
                    </ul>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">3. Account Registration</h2>
                    <p class="text-gray-700 mb-4 leading-relaxed">
                        To make purchases, you may be required to create an account. You agree to:
                    </p>
                    <ul class="list-disc list-inside space-y-2 text-gray-700 ml-4 mb-6">
                        <li>Provide accurate, current, and complete information</li>
                        <li>Maintain and update your information to keep it accurate</li>
                        <li>Maintain the security of your password and account</li>
                        <li>Accept responsibility for all activities under your account</li>
                        <li>Notify us immediately of any unauthorized use</li>
                    </ul>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">4. Products and Pricing</h2>
                    <p class="text-gray-700 mb-4 leading-relaxed">
                        We strive to provide accurate product descriptions and pricing. However:
                    </p>
                    <ul class="list-disc list-inside space-y-2 text-gray-700 ml-4 mb-6">
                        <li>We reserve the right to correct any errors in pricing or product information</li>
                        <li>Product images are for illustrative purposes and may not reflect exact colors or details</li>
                        <li>We reserve the right to refuse or cancel orders at our discretion</li>
                        <li>Prices are subject to change without notice</li>
                    </ul>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">5. Orders and Payment</h2>
                    <p class="text-gray-700 mb-4 leading-relaxed">
                        When you place an order:
                    </p>
                    <ul class="list-disc list-inside space-y-2 text-gray-700 ml-4 mb-6">
                        <li>You agree to provide valid payment information</li>
                        <li>Payment must be received before we process your order</li>
                        <li>We reserve the right to cancel orders due to pricing errors or product unavailability</li>
                        <li>Order confirmation does not guarantee product availability</li>
                    </ul>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">6. Shipping and Delivery</h2>
                    <p class="text-gray-700 mb-4 leading-relaxed">
                        Shipping terms:
                    </p>
                    <ul class="list-disc list-inside space-y-2 text-gray-700 ml-4 mb-6">
                        <li>Delivery times are estimates and not guaranteed</li>
                        <li>We are not responsible for delays caused by shipping carriers</li>
                        <li>Risk of loss passes to you upon delivery to the carrier</li>
                        <li>You are responsible for providing accurate shipping addresses</li>
                    </ul>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">7. Returns and Refunds</h2>
                    <p class="text-gray-700 mb-4 leading-relaxed">
                        Our return policy:
                    </p>
                    <ul class="list-disc list-inside space-y-2 text-gray-700 ml-4 mb-6">
                        <li>Items must be returned within the specified return period</li>
                        <li>Products must be in original condition with tags attached</li>
                        <li>Refunds will be processed to the original payment method</li>
                        <li>Shipping costs for returns are the customer's responsibility unless otherwise stated</li>
                    </ul>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">8. Intellectual Property</h2>
                    <p class="text-gray-700 mb-6 leading-relaxed">
                        All content on this website, including text, graphics, logos, images, and software, is the property of 
                        {{ $siteTitle ?? 'Vibrant Vogue' }} or its content suppliers and is protected by copyright and trademark laws. 
                        You may not reproduce, distribute, or create derivative works without our written permission.
                    </p>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">9. Limitation of Liability</h2>
                    <p class="text-gray-700 mb-6 leading-relaxed">
                        To the fullest extent permitted by law, {{ $siteTitle ?? 'Vibrant Vogue' }} shall not be liable for any indirect, 
                        incidental, special, consequential, or punitive damages resulting from your use of or inability to use our website 
                        or services.
                    </p>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">10. Indemnification</h2>
                    <p class="text-gray-700 mb-6 leading-relaxed">
                        You agree to indemnify and hold harmless {{ $siteTitle ?? 'Vibrant Vogue' }}, its officers, directors, employees, 
                        and agents from any claims, damages, losses, liabilities, and expenses arising from your use of the website or 
                        violation of these terms.
                    </p>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">11. Governing Law</h2>
                    <p class="text-gray-700 mb-6 leading-relaxed">
                        These Terms and Conditions shall be governed by and construed in accordance with the laws of [Your Jurisdiction], 
                        without regard to its conflict of law provisions.
                    </p>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">12. Changes to Terms</h2>
                    <p class="text-gray-700 mb-6 leading-relaxed">
                        We reserve the right to modify these Terms and Conditions at any time. Changes will be effective immediately upon 
                        posting. Your continued use of the website constitutes acceptance of the modified terms.
                    </p>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">13. Contact Information</h2>
                    <p class="text-gray-700 mb-4 leading-relaxed">
                        If you have questions about these Terms and Conditions, please contact us:
                    </p>
                    <div class="bg-gray-50 rounded-lg p-6">
                        <p class="text-gray-700 mb-2"><strong>Email:</strong> legal@example.com</p>
                        <p class="text-gray-700 mb-2"><strong>Address:</strong> [Your Business Address]</p>
                        <p class="text-gray-700"><strong>Phone:</strong> [Your Contact Number]</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

