@extends('layouts.app')

@section('title', 'Privacy Policy')

@section('content')
<div class="min-h-screen bg-gray-50">
    <!-- Hero Section -->
    <section class="text-white py-16 md:py-24" style="background: linear-gradient(135deg, {{ $primaryColor ?? '#ff5349' }} 0%, {{ $primaryColor ?? '#ff5349' }}dd 100%);">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center max-w-3xl mx-auto">
                <h1 class="text-4xl md:text-5xl lg:text-6xl font-black mb-6 text-white">Privacy Policy</h1>
                <p class="text-xl md:text-2xl text-white/90 leading-relaxed">
                    Your privacy is important to us. Learn how we collect, use, and protect your information.
                </p>
            </div>
        </div>
    </section>

    <!-- Main Content -->
    <section class="py-12 md:py-16">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-white rounded-xl shadow-lg p-8 md:p-12 space-y-8">
                <p class="text-sm text-gray-500 mb-8">
                    Last updated: {{ date('F d, Y') }}
                </p>

                <div class="prose prose-lg max-w-none">
                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">1. Introduction</h2>
                    <p class="text-gray-700 mb-6 leading-relaxed">
                        At {{ $siteTitle ?? 'Vibrant Vogue' }} ("we," "our," or "us"), we are committed to protecting your privacy. 
                        This Privacy Policy explains how we collect, use, disclose, and safeguard your information when you visit 
                        our website and use our services.
                    </p>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">2. Information We Collect</h2>
                    <p class="text-gray-700 mb-4 leading-relaxed">
                        We collect information that you provide directly to us, including:
                    </p>
                    <ul class="list-disc list-inside space-y-2 text-gray-700 ml-4 mb-6">
                        <li>Personal information (name, email address, phone number, shipping address)</li>
                        <li>Payment information (processed securely through our payment providers)</li>
                        <li>Account credentials (username, password)</li>
                        <li>Order history and preferences</li>
                        <li>Communication preferences</li>
                    </ul>
                    <p class="text-gray-700 mb-6 leading-relaxed">
                        We also automatically collect certain information when you visit our website, such as:
                    </p>
                    <ul class="list-disc list-inside space-y-2 text-gray-700 ml-4 mb-6">
                        <li>Device information (IP address, browser type, operating system)</li>
                        <li>Usage data (pages visited, time spent, click patterns)</li>
                        <li>Cookies and similar tracking technologies</li>
                    </ul>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">3. How We Use Your Information</h2>
                    <p class="text-gray-700 mb-4 leading-relaxed">
                        We use the information we collect to:
                    </p>
                    <ul class="list-disc list-inside space-y-2 text-gray-700 ml-4 mb-6">
                        <li>Process and fulfill your orders</li>
                        <li>Send you order confirmations and updates</li>
                        <li>Respond to your inquiries and provide customer support</li>
                        <li>Send you marketing communications (with your consent)</li>
                        <li>Improve our website and services</li>
                        <li>Prevent fraud and ensure security</li>
                        <li>Comply with legal obligations</li>
                    </ul>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">4. Information Sharing</h2>
                    <p class="text-gray-700 mb-6 leading-relaxed">
                        We do not sell your personal information. We may share your information with:
                    </p>
                    <ul class="list-disc list-inside space-y-2 text-gray-700 ml-4 mb-6">
                        <li>Service providers who assist us in operating our website and conducting our business</li>
                        <li>Payment processors to handle transactions</li>
                        <li>Shipping companies to deliver your orders</li>
                        <li>Legal authorities when required by law</li>
                    </ul>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">5. Data Security</h2>
                    <p class="text-gray-700 mb-6 leading-relaxed">
                        We implement appropriate technical and organizational measures to protect your personal information 
                        against unauthorized access, alteration, disclosure, or destruction. However, no method of transmission 
                        over the internet is 100% secure, and we cannot guarantee absolute security.
                    </p>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">6. Your Rights</h2>
                    <p class="text-gray-700 mb-4 leading-relaxed">
                        You have the right to:
                    </p>
                    <ul class="list-disc list-inside space-y-2 text-gray-700 ml-4 mb-6">
                        <li>Access and receive a copy of your personal information</li>
                        <li>Correct inaccurate or incomplete information</li>
                        <li>Request deletion of your personal information</li>
                        <li>Object to processing of your personal information</li>
                        <li>Withdraw consent for marketing communications</li>
                        <li>Request data portability</li>
                    </ul>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">7. Cookies</h2>
                    <p class="text-gray-700 mb-6 leading-relaxed">
                        We use cookies and similar technologies to enhance your browsing experience, analyze website traffic, 
                        and personalize content. You can control cookies through your browser settings, but this may affect 
                        website functionality.
                    </p>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">8. Third-Party Links</h2>
                    <p class="text-gray-700 mb-6 leading-relaxed">
                        Our website may contain links to third-party websites. We are not responsible for the privacy practices 
                        of these external sites. We encourage you to review their privacy policies.
                    </p>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">9. Children's Privacy</h2>
                    <p class="text-gray-700 mb-6 leading-relaxed">
                        Our services are not intended for individuals under the age of 18. We do not knowingly collect personal 
                        information from children. If you believe we have collected information from a child, please contact us immediately.
                    </p>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">10. Changes to This Policy</h2>
                    <p class="text-gray-700 mb-6 leading-relaxed">
                        We may update this Privacy Policy from time to time. We will notify you of any changes by posting the 
                        new policy on this page and updating the "Last updated" date. We encourage you to review this policy periodically.
                    </p>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">11. Contact Us</h2>
                    <p class="text-gray-700 mb-4 leading-relaxed">
                        If you have questions or concerns about this Privacy Policy or our data practices, please contact us:
                    </p>
                    <div class="bg-gray-50 rounded-lg p-6">
                        <p class="text-gray-700 mb-2"><strong>Email:</strong> privacy@example.com</p>
                        <p class="text-gray-700 mb-2"><strong>Address:</strong> [Your Business Address]</p>
                        <p class="text-gray-700"><strong>Phone:</strong> [Your Contact Number]</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

