@extends('layouts.app')

@section('title', 'About Us')

@section('content')
<div class="min-h-screen bg-gray-50">
    <!-- Hero Section -->
    <section class="text-white py-16 md:py-24" style="background: linear-gradient(135deg, {{ $primaryColor ?? '#ff5349' }} 0%, {{ $primaryColor ?? '#ff5349' }}dd 100%);">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center max-w-3xl mx-auto">
                <h1 class="text-4xl md:text-5xl lg:text-6xl font-black mb-6 text-white">About Us</h1>
                <p class="text-xl md:text-2xl text-white/90 leading-relaxed">
                    Discover the story behind {{ $siteTitle ?? 'Vibrant Vogue' }} and our passion for fashion
                </p>
            </div>
        </div>
    </section>

    <!-- Main Content -->
    <section class="py-12 md:py-16">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-white rounded-xl shadow-lg p-8 md:p-12 space-y-8">
                <!-- Our Story -->
                <div>
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Our Story</h2>
                    <div class="prose prose-lg max-w-none text-gray-700 leading-relaxed">
                        <p class="mb-4">
                            Welcome to {{ $siteTitle ?? 'Vibrant Vogue' }}, where fashion meets passion and style knows no boundaries. 
                            Founded with a vision to make high-quality fashion accessible to everyone, we've been dedicated to 
                            curating the finest collection of clothing and accessories that reflect your unique personality.
                        </p>
                        <p class="mb-4">
                            Our journey began with a simple belief: everyone deserves to look and feel their best. We carefully 
                            select each piece in our collection, ensuring that quality, style, and affordability go hand in hand. 
                            From timeless classics to the latest trends, we bring you fashion that speaks to your individuality.
                        </p>
                        <p>
                            At {{ $siteTitle ?? 'Vibrant Vogue' }}, we're more than just a fashion store—we're your style partner, 
                            committed to helping you express yourself through the clothes you wear.
                        </p>
                    </div>
                </div>

                <!-- Our Mission -->
                <div class="border-t border-gray-200 pt-8">
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Our Mission</h2>
                    <div class="prose prose-lg max-w-none text-gray-700 leading-relaxed">
                        <p class="mb-4">
                            Our mission is to empower individuals to express their unique style through high-quality, 
                            affordable fashion. We strive to:
                        </p>
                        <ul class="list-disc list-inside space-y-2 ml-4">
                            <li>Provide exceptional quality products at competitive prices</li>
                            <li>Offer a diverse range of styles to suit every taste and occasion</li>
                            <li>Deliver outstanding customer service that exceeds expectations</li>
                            <li>Stay ahead of fashion trends while maintaining timeless elegance</li>
                            <li>Build a community of fashion enthusiasts who share our passion</li>
                        </ul>
                    </div>
                </div>

                <!-- Our Values -->
                <div class="border-t border-gray-200 pt-8">
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-6">Our Values</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="bg-gray-50 rounded-lg p-6">
                            <h3 class="text-xl font-bold text-primary mb-3">Quality First</h3>
                            <p class="text-gray-700">
                                We never compromise on quality. Every product in our collection is carefully selected 
                                to meet our high standards of craftsmanship and durability.
                            </p>
                        </div>
                        <div class="bg-gray-50 rounded-lg p-6">
                            <h3 class="text-xl font-bold text-primary mb-3">Customer Focus</h3>
                            <p class="text-gray-700">
                                Your satisfaction is our priority. We're committed to providing exceptional service 
                                and ensuring every shopping experience is enjoyable and seamless.
                            </p>
                        </div>
                        <div class="bg-gray-50 rounded-lg p-6">
                            <h3 class="text-xl font-bold text-primary mb-3">Innovation</h3>
                            <p class="text-gray-700">
                                We continuously evolve with the fashion industry, bringing you the latest trends 
                                and innovative styles that keep you ahead of the curve.
                            </p>
                        </div>
                        <div class="bg-gray-50 rounded-lg p-6">
                            <h3 class="text-xl font-bold text-primary mb-3">Integrity</h3>
                            <p class="text-gray-700">
                                We conduct our business with honesty, transparency, and ethical practices. 
                                Trust is the foundation of everything we do.
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Why Choose Us -->
                <div class="border-t border-gray-200 pt-8">
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-6">Why Choose Us</h2>
                    <div class="space-y-4">
                        <div class="flex items-start gap-4">
                            <div class="flex-shrink-0 w-12 h-12 bg-primary/10 rounded-full flex items-center justify-center">
                                <svg class="w-6 h-6 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-xl font-semibold text-gray-900 mb-2">Curated Selection</h3>
                                <p class="text-gray-700">
                                    Our team of fashion experts handpicks every item, ensuring you get only the best 
                                    quality products that match current trends and timeless styles.
                                </p>
                            </div>
                        </div>
                        <div class="flex items-start gap-4">
                            <div class="flex-shrink-0 w-12 h-12 bg-primary/10 rounded-full flex items-center justify-center">
                                <svg class="w-6 h-6 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-xl font-semibold text-gray-900 mb-2">Affordable Prices</h3>
                                <p class="text-gray-700">
                                    We believe great fashion shouldn't break the bank. Our competitive pricing ensures 
                                    you get excellent value for your money without compromising on quality.
                                </p>
                            </div>
                        </div>
                        <div class="flex items-start gap-4">
                            <div class="flex-shrink-0 w-12 h-12 bg-primary/10 rounded-full flex items-center justify-center">
                                <svg class="w-6 h-6 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-xl font-semibold text-gray-900 mb-2">Fast Shipping</h3>
                                <p class="text-gray-700">
                                    We understand you want your new fashion pieces as soon as possible. That's why we 
                                    offer fast and reliable shipping to get your orders to you quickly and safely.
                                </p>
                            </div>
                        </div>
                        <div class="flex items-start gap-4">
                            <div class="flex-shrink-0 w-12 h-12 bg-primary/10 rounded-full flex items-center justify-center">
                                <svg class="w-6 h-6 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-xl font-semibold text-gray-900 mb-2">Easy Returns</h3>
                                <p class="text-gray-700">
                                    Not satisfied? No problem! We offer hassle-free returns and exchanges to ensure 
                                    you're completely happy with your purchase.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Contact Section -->
                <div class="border-t border-gray-200 pt-8">
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Get in Touch</h2>
                    <p class="text-gray-700 mb-6">
                        Have questions or want to learn more about us? We'd love to hear from you!
                    </p>
                    <a href="#" class="inline-flex items-center gap-2 bg-primary text-white px-6 py-3 rounded-lg font-semibold hover:bg-primary-dark transition">
                        Contact Us
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

