@extends('layouts.app')

@section('title', 'My Orders')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <h1 class="font-display text-3xl font-bold text-gray-900 mb-8">My Orders</h1>

    @if($orders->count() > 0)
        <div class="space-y-6">
            @foreach($orders as $order)
                <div class="bg-white rounded-lg shadow-md p-6">
                    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-4">
                        <div>
                            <h3 class="font-semibold text-lg text-gray-900">Order #{{ $order->order_number }}</h3>
                            <p class="text-gray-600 text-sm">Placed on {{ $order->created_at->format('M d, Y') }}</p>
                        </div>
                        <div class="mt-4 md:mt-0 text-right">
                            <span class="inline-block px-3 py-1 rounded-full text-sm font-semibold
                                @if($order->status == 'pending') bg-yellow-100 text-yellow-800
                                @elseif($order->status == 'processing') bg-blue-100 text-blue-800
                                @elseif($order->status == 'shipped') bg-purple-100 text-purple-800
                                @elseif($order->status == 'delivered') bg-green-100 text-green-800
                                @else bg-red-100 text-red-800
                                @endif">
                                {{ ucfirst($order->status) }}
                            </span>
                            <p class="text-gray-900 font-bold text-lg mt-2">{{ currency($order->total) }}</p>
                        </div>
                    </div>
                    <div class="border-t border-gray-200 pt-4">
                        <div class="flex items-center justify-between">
                            <a href="{{ route('orders.show', $order->id) }}" class="text-primary hover:text-primary-dark transition font-semibold">
                                View Details
                            </a>
                            <span class="text-gray-600 text-sm">{{ $order->items->count() }} item(s)</span>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <!-- Pagination -->
        <div class="mt-8">
            {{ $orders->links() }}
        </div>
    @else
        <div class="text-center py-12 bg-white rounded-lg shadow-md">
            <svg class="w-24 h-24 mx-auto text-gray-400 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
            </svg>
            <h2 class="font-display text-2xl font-bold text-gray-900 mb-4">No orders yet</h2>
            <p class="text-gray-600 mb-6">Start shopping to see your orders here!</p>
            <a href="{{ route('products.index') }}" class="inline-block bg-primary text-white px-6 py-3 rounded-md font-semibold hover:bg-primary-dark transition">
                Browse Products
            </a>
        </div>
    @endif
</div>
@endsection

