@extends('layouts.app')

@section('title', 'Checkout')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <h1 class="font-display text-3xl font-bold text-gray-900 mb-8">Checkout</h1>

    <form action="{{ route('orders.store') }}" method="POST" class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        @csrf

        <!-- Checkout Information -->
        <div class="lg:col-span-2 space-y-6">
            <div class="bg-white rounded-lg shadow-md p-6">
                <h2 class="font-display text-2xl font-bold text-gray-900 mb-6">Checkout Information</h2>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Full Name *</label>
                        <input type="text" name="shipping_name" value="{{ old('shipping_name', auth()->check() ? auth()->user()->name : '') }}" required class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-primary">
                        @error('shipping_name')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Email *</label>
                        <input type="email" name="shipping_email" value="{{ old('shipping_email', auth()->check() ? auth()->user()->email : '') }}" required class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-primary">
                        @error('shipping_email')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Phone *</label>
                        <input type="tel" name="shipping_phone" value="{{ old('shipping_phone') }}" required class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-primary">
                        @error('shipping_phone')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Address *</label>
                        <textarea name="shipping_address" rows="3" required class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-primary">{{ old('shipping_address') }}</textarea>
                        @error('shipping_address')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Payment Method -->
            <div class="bg-white rounded-lg shadow-md p-6">
                <h2 class="font-display text-2xl font-bold text-gray-900 mb-6">Payment Method</h2>
                <div class="space-y-4">
                    <div class="p-4 border border-gray-200 rounded-md hover:bg-gray-50 cursor-pointer">
                        <label class="flex items-center cursor-pointer w-full">
                            <input type="radio" name="payment_method" value="cash_on_delivery" checked class="h-5 w-5 text-primary border-gray-300 focus:ring-primary">
                            <span class="ml-3 text-lg font-semibold text-gray-900">Cash on Delivery</span>
                        </label>
                    </div>
                    <div class="p-4 border border-gray-200 rounded-md hover:bg-gray-50 cursor-pointer">
                        <label class="flex items-center cursor-pointer w-full">
                            <input type="radio" name="payment_method" value="paystack" class="h-5 w-5 text-primary border-gray-300 focus:ring-primary">
                            <span class="ml-3 text-lg font-semibold text-gray-900">Paystack (Credit/Debit Card)</span>
                        </label>
                    </div>
                </div>
            </div>

            <!-- Notes -->
            <div class="bg-white rounded-lg shadow-md p-6">
                <label class="block text-sm font-medium text-gray-700 mb-2">Order Notes (Optional)</label>
                <textarea name="notes" rows="4" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-primary">{{ old('notes') }}</textarea>
            </div>
        </div>

        <!-- Order Summary -->
        <div class="lg:col-span-1">
            <div class="bg-white rounded-lg shadow-md p-6 sticky top-20">
                <h2 class="font-display text-2xl font-bold text-gray-900 mb-6">Order Summary</h2>
                <div class="space-y-4 mb-6">
                    @foreach($cartItems as $item)
                        @if($item->product)
                        <div class="flex gap-4 pb-4 border-b border-gray-200">
                            <div class="w-16 h-16 bg-gray-200 rounded-lg overflow-hidden flex-shrink-0">
                                <img src="{{ productImageUrl($item->product->image ?? '') }}" alt="{{ $item->product->name }}" class="w-full h-full object-cover"
                                     onerror="this.src='{{ asset('images/placeholder.jpg') }}'; this.onerror=null;">
                            </div>
                            <div class="flex-1">
                                <h3 class="font-semibold text-sm text-gray-900">{{ $item->product->name }}</h3>
                                <p class="text-gray-600 text-xs">Qty: {{ $item->quantity }}</p>
                                <p class="text-primary font-semibold text-sm">{{ currency($item->subtotal) }}</p>
                            </div>
                        </div>
                        @endif
                    @endforeach
                    <div class="space-y-2 pt-4">
                        <div class="flex justify-between text-gray-700">
                            <span>Subtotal</span>
                            <span>{{ currency($subtotal) }}</span>
                        </div>
                        <div class="border-t border-gray-300 pt-4">
                            <div class="flex justify-between text-gray-900 font-bold text-lg">
                                <span>Total</span>
                                <span>{{ currency($total) }}</span>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="submit" id="place-order-btn" class="w-full bg-primary text-white px-6 py-3 rounded-md text-center font-semibold hover:bg-primary-dark transition disabled:opacity-50 disabled:cursor-not-allowed">
                    <span id="btn-text">Place Order</span>
                    <span id="btn-loading" class="hidden">Processing...</span>
                </button>
            </div>
        </div>
    </form>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('form[action="{{ route('orders.store') }}"]');
    const submitBtn = document.getElementById('place-order-btn');
    const btnText = document.getElementById('btn-text');
    const btnLoading = document.getElementById('btn-loading');
    let isSubmitting = false;

    if (form && submitBtn) {
        form.addEventListener('submit', function(e) {
            if (isSubmitting) {
                e.preventDefault();
                return false;
            }

            isSubmitting = true;
            submitBtn.disabled = true;
            btnText.classList.add('hidden');
            btnLoading.classList.remove('hidden');
        });
    }
});
</script>
@endpush
@endsection

