<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Welcome to {{ $siteTitle ?? 'Vibrant Vogue' }}</title>
</head>
<body style="margin: 0; padding: 0; background-color: #fef7ed; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;">
    <table role="presentation" width="100%" cellpadding="0" cellspacing="0" style="background-color: #fef7ed; padding: 60px 20px;">
        <tr>
            <td align="center">
                <table role="presentation" width="600" cellpadding="0" cellspacing="0" style="background-color: #ffffff; border-radius: 16px; overflow: hidden; box-shadow: 0 8px 24px rgba(0,0,0,0.08);">
                    
                    <!-- Logo/Header Area -->
                    <tr>
                        <td style="padding: 40px 40px 20px 40px; text-align: left;">
                            <div style="width: 60px; height: 60px; background-color: {{ $primaryColor ?? '#ff5349' }}; border-radius: 12px; display: inline-block;"></div>
                        </td>
                    </tr>
                    
                    <!-- Main Content -->
                    <tr>
                        <td style="padding: 0 40px 40px 40px;">
                            <!-- Greeting -->
                            <p style="color: #6b7280; font-size: 16px; margin: 0 0 10px 0; font-weight: 400;">Hello, {{ $user->name }}</p>
                            <h1 style="color: {{ $primaryColor ?? '#ff5349' }}; font-size: 36px; font-weight: 700; margin: 0 0 30px 0; letter-spacing: -0.5px; line-height: 1.2;">Nice to meet you!</h1>
                            
                            <!-- Decorative Illustration Area -->
                            <div style="background: linear-gradient(135deg, #fff5e6 0%, #ffe8cc 100%); border-radius: 20px; padding: 50px 30px; margin: 40px 0; text-align: center; position: relative; overflow: hidden;">
                                <!-- Simple decorative elements -->
                                <div style="font-size: 80px; line-height: 1; margin-bottom: 20px;">🎁</div>
                                <div style="position: absolute; top: 20px; right: 30px; width: 40px; height: 40px; background-color: {{ $primaryColor ?? '#ff5349' }}20; border-radius: 50%;"></div>
                                <div style="position: absolute; bottom: 30px; left: 40px; width: 30px; height: 30px; background-color: {{ $primaryColor ?? '#ff5349' }}15; border-radius: 50%;"></div>
                            </div>
                            
                            <!-- Welcome Message -->
                            <p style="color: #4a4a4a; font-size: 16px; line-height: 1.8; margin: 0 0 35px 0;">
                                Welcome to {{ $siteTitle ?? 'Vibrant Vogue' }}! We're thrilled to have you join our fashion community. Your account has been successfully created and you're all set to start shopping.
                            </p>
                            
                            <!-- CTA Button -->
                            <table role="presentation" width="100%" cellpadding="0" cellspacing="0" style="margin: 40px 0;">
                                <tr>
                                    <td align="center">
                                        <a href="{{ url('/') }}" style="display: inline-block; background-color: {{ $primaryColor ?? '#ff5349' }}; color: #ffffff; padding: 18px 40px; text-decoration: none; border-radius: 12px; font-weight: 700; font-size: 16px; letter-spacing: 0.5px; text-transform: uppercase; box-shadow: 0 4px 12px rgba(255, 83, 73, 0.3);">Start Shopping</a>
                                    </td>
                                </tr>
                            </table>
                            
                            <!-- What's Next -->
                            <div style="background-color: #f9fafb; border-radius: 12px; padding: 25px; margin: 35px 0;">
                                <p style="color: #1a1a1a; font-size: 16px; font-weight: 600; margin: 0 0 15px 0;">What you can do now:</p>
                                <ul style="color: #6b7280; font-size: 15px; line-height: 1.8; margin: 0; padding-left: 20px;">
                                    <li style="margin-bottom: 8px;">Browse our latest fashion collections</li>
                                    <li style="margin-bottom: 8px;">Add items to your wishlist</li>
                                    <li style="margin-bottom: 8px;">Track your orders in real-time</li>
                                    <li>Enjoy exclusive member benefits</li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                    
                    <!-- Footer -->
                    <tr>
                        <td style="background-color: #f9fafb; padding: 35px 40px; text-align: center; border-top: 1px solid #e5e7eb;">
                            <p style="color: #1a1a1a; font-size: 16px; font-weight: 700; margin: 0 0 8px 0;">Thank you for choosing {{ $siteTitle ?? 'Vibrant Vogue' }}</p>
                            <p style="color: #6b7280; font-size: 14px; margin: 0 0 12px 0;">Explore fashion trends and style inspiration</p>
                            <p style="color: #9ca3af; font-size: 12px; margin: 0; line-height: 1.6;">
                                Fashion is already here, built into our collections and available for you to discover and create your own unique style.
                            </p>
                            <p style="color: #9ca3af; font-size: 11px; margin: 20px 0 0 0;">
                                &copy; {{ date('Y') }} {{ $siteTitle ?? 'Vibrant Vogue' }}. All rights reserved.
                            </p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>
