@extends('layouts.app')

@section('title', 'Verify Email')

@section('content')
<div class="min-h-screen flex items-center justify-center bg-gradient-to-br from-gray-50 via-white to-gray-100 py-12 px-4 sm:px-6 lg:px-8">
    <div class="max-w-md w-full">
        <!-- Logo/Brand Section -->
        <div class="text-center mb-8">
            <a href="{{ route('home') }}" class="inline-block">
                @if(isset($siteLogo) && $siteLogo)
                    <img src="{{ productImageUrl($siteLogo ?? '') }}" 
                         alt="{{ $siteTitle ?? 'Vibrant Vogue' }}" 
                         class="h-16 mx-auto mb-4 object-contain"
                         onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                    <h1 class="text-3xl font-black logo-outline" style="display: none;">{{ strtoupper($siteTitle ?? 'VIBRANT VOGUE') }}</h1>
                @else
                    <h1 class="text-3xl font-black logo-outline">{{ strtoupper($siteTitle ?? 'VIBRANT VOGUE') }}</h1>
                @endif
            </a>
            <p class="mt-2 text-sm text-gray-600">Please verify your email address to continue.</p>
        </div>

        <!-- Verification Card -->
        <div class="bg-white rounded-2xl shadow-xl overflow-hidden">
            <div class="px-8 py-10 sm:px-10">
                @if(session('success'))
                    <div class="mb-6 bg-green-50 border-l-4 border-green-500 text-green-700 p-4 rounded-lg" role="alert">
                        <div class="flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                            </svg>
                            <p class="text-sm font-medium">{{ session('success') }}</p>
                        </div>
                    </div>
                @endif

                @if(session('error'))
                    <div class="mb-6 bg-red-50 border-l-4 border-red-500 text-red-700 p-4 rounded-lg" role="alert">
                        <div class="flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                            </svg>
                            <p class="text-sm font-medium">{{ session('error') }}</p>
                        </div>
                    </div>
                @endif

                <h2 class="text-2xl font-bold text-gray-900 mb-2 text-center">Verify Your Email</h2>
                <p class="text-center text-gray-600 mb-8">We've sent a 6-digit verification code to</p>
                <p class="text-center text-primary font-semibold mb-8">{{ $user->email }}</p>
                
                @if(isset($lastOtp) && $lastOtp)
                    <div class="mb-6 p-4 bg-yellow-50 border-l-4 border-yellow-400 rounded">
                        <p class="text-sm text-yellow-800 font-semibold mb-2">⚠️ Debug Mode: Your verification code is</p>
                        <p class="text-2xl font-bold text-center text-yellow-900 tracking-widest">{{ $lastOtp }}</p>
                        <p class="text-xs text-yellow-700 text-center mt-2">This is only visible for testing. Check your email for the actual code.</p>
                    </div>
                @endif

                <form method="POST" action="{{ route('verify.email') }}" class="space-y-6" id="verifyForm" onsubmit="return normalizeOtpInput(event);">
                    @csrf

                    <!-- OTP Input Field -->
                    <div>
                        <label for="otp" class="block text-sm font-semibold text-gray-700 mb-2 text-center">
                            Enter Verification Code
                        </label>
                        <div class="flex justify-center">
                            <input type="text" 
                                   name="otp" 
                                   id="otp" 
                                   required 
                                   maxlength="6"
                                   pattern="[0-9]{6}"
                                   placeholder="000000"
                                   autofocus
                                   class="block w-full max-w-xs text-center text-3xl font-bold tracking-widest border-2 border-gray-200 rounded-lg px-4 py-4 focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition @error('otp') border-red-500 @enderror"
                                   oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 6);"
                                   onpaste="setTimeout(() => { this.value = this.value.replace(/[^0-9]/g, '').slice(0, 6); }, 10);">
                        </div>
                        @error('otp')
                            <p class="mt-2 text-sm text-red-600 flex items-center justify-center">
                                <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                                </svg>
                                {{ $message }}
                            </p>
                        @enderror
                        <p class="mt-2 text-xs text-gray-500 text-center">Code expires in 15 minutes</p>
                    </div>

                    <!-- Submit Button -->
                    <button type="submit" 
                            class="w-full bg-primary text-white px-6 py-3 rounded-lg font-bold text-lg hover:bg-primary-dark transition shadow-lg hover:shadow-xl transform hover:-translate-y-0.5">
                        Verify Email
                    </button>
                </form>

                <script>
                    function normalizeOtpInput(event) {
                        const otpInput = document.getElementById('otp');
                        if (otpInput) {
                            // Remove all non-numeric characters and ensure exactly 6 digits
                            let cleanedValue = otpInput.value.replace(/[^0-9]/g, '').slice(0, 6);
                            
                            // Pad with zeros if less than 6 digits (though this shouldn't happen with validation)
                            if (cleanedValue.length < 6) {
                                cleanedValue = cleanedValue.padStart(6, '0');
                            }
                            
                            // Update the input value
                            otpInput.value = cleanedValue;
                            
                            // Validate length
                            if (cleanedValue.length !== 6) {
                                event.preventDefault();
                                alert('Please enter a 6-digit verification code.');
                                return false;
                            }
                        }
                        return true;
                    }
                </script>

                <!-- Resend OTP -->
                <div class="mt-8">
                    <form method="POST" action="{{ route('resend.otp') }}">
                        @csrf
                        <div class="text-center">
                            <p class="text-sm text-gray-600 mb-2">Didn't receive the code?</p>
                            <button type="submit" 
                                    class="text-primary font-semibold hover:text-primary-dark transition inline-flex items-center">
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                                </svg>
                                Resend Code
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Divider -->
                <div class="mt-8 mb-6">
                    <div class="relative">
                        <div class="absolute inset-0 flex items-center">
                            <div class="w-full border-t border-gray-200"></div>
                        </div>
                        <div class="relative flex justify-center text-sm">
                            <span class="px-4 bg-white text-gray-500">Need help?</span>
                        </div>
                    </div>
                </div>

                <!-- Back to Register Link -->
                <div class="text-center">
                    <a href="{{ route('register') }}" 
                       class="text-sm text-gray-600 hover:text-primary transition inline-flex items-center">
                        <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                        </svg>
                        Back to registration
                    </a>
                </div>
            </div>
        </div>

        <!-- Back to Home Link -->
        <div class="mt-6 text-center">
            <a href="{{ route('home') }}" 
               class="text-sm text-gray-600 hover:text-primary transition inline-flex items-center">
                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                </svg>
                Back to home
            </a>
        </div>
    </div>
</div>
@endsection

