@extends('layouts.app')

@section('title', 'Reset Password')

@section('content')
<div class="min-h-screen flex items-center justify-center bg-gradient-to-br from-gray-50 via-white to-gray-100 py-12 px-4 sm:px-6 lg:px-8">
    <div class="max-w-md w-full">
        <!-- Logo/Brand Section -->
        <div class="text-center mb-8">
            <a href="{{ route('home') }}" class="inline-block">
                @if(isset($siteLogo) && $siteLogo)
                    <img src="{{ productImageUrl($siteLogo ?? '') }}" 
                         alt="{{ $siteTitle ?? 'Vibrant Vogue' }}" 
                         class="h-16 mx-auto mb-4 object-contain"
                         onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                    <h1 class="text-3xl font-black logo-outline" style="display: none;">{{ strtoupper($siteTitle ?? 'VIBRANT VOGUE') }}</h1>
                @else
                    <h1 class="text-3xl font-black logo-outline">{{ strtoupper($siteTitle ?? 'VIBRANT VOGUE') }}</h1>
                @endif
            </a>
            <p class="mt-2 text-sm text-gray-600">Enter the code sent to your email and your new password.</p>
        </div>

        <!-- Reset Password Card -->
        <div class="bg-white rounded-2xl shadow-xl overflow-hidden">
            <div class="px-8 py-10 sm:px-10">
                @if(session('success'))
                    <div class="mb-6 bg-green-50 border-l-4 border-green-500 text-green-700 p-4 rounded-lg" role="alert">
                        <div class="flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                            </svg>
                            <p class="text-sm font-medium">{{ session('success') }}</p>
                        </div>
                    </div>
                @endif

                @if(session('error'))
                    <div class="mb-6 bg-red-50 border-l-4 border-red-500 text-red-700 p-4 rounded-lg" role="alert">
                        <div class="flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                            </svg>
                            <p class="text-sm font-medium">{{ session('error') }}</p>
                        </div>
                    </div>
                @endif

                <h2 class="text-2xl font-bold text-gray-900 mb-2 text-center">Reset Password</h2>
                <p class="text-center text-gray-600 mb-8">We've sent a 6-digit verification code to</p>
                <p class="text-center text-primary font-semibold mb-8">{{ $user->email }}</p>
                
                @if(isset($lastOtp) && $lastOtp)
                    <div class="mb-6 p-4 bg-yellow-50 border-l-4 border-yellow-400 rounded">
                        <p class="text-sm text-yellow-800 font-semibold mb-2">⚠️ Debug Mode: Your reset code is</p>
                        <p class="text-2xl font-bold text-center text-yellow-900 tracking-widest">{{ $lastOtp }}</p>
                        <p class="text-xs text-yellow-700 text-center mt-2">This is only visible for testing. Check your email for the actual code.</p>
                    </div>
                @endif

                <form method="POST" action="{{ route('password.update') }}" class="space-y-6" id="resetForm" onsubmit="return normalizeOtpInput(event);">
                    @csrf

                    <!-- OTP Input Field -->
                    <div>
                        <label for="otp" class="block text-sm font-semibold text-gray-700 mb-2 text-center">
                            Enter Verification Code
                        </label>
                        <div class="flex justify-center">
                            <input type="text" 
                                   name="otp" 
                                   id="otp" 
                                   required 
                                   maxlength="6"
                                   pattern="[0-9]{6}"
                                   placeholder="000000"
                                   autofocus
                                   class="block w-full max-w-xs text-center text-3xl font-bold tracking-widest border-2 border-gray-200 rounded-lg px-4 py-4 focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition @error('otp') border-red-500 @enderror"
                                   oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 6);"
                                   onpaste="setTimeout(() => { this.value = this.value.replace(/[^0-9]/g, '').slice(0, 6); }, 10);">
                        </div>
                        @error('otp')
                            <p class="mt-2 text-sm text-red-600 flex items-center justify-center">
                                <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                                </svg>
                                {{ $message }}
                            </p>
                        @enderror
                        <p class="mt-2 text-xs text-gray-500 text-center">Code expires in 15 minutes</p>
                    </div>

                    <!-- New Password Field -->
                    <div>
                        <label for="password" class="block text-sm font-semibold text-gray-700 mb-2">
                            New Password
                        </label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                                </svg>
                            </div>
                            <input type="password" 
                                   name="password" 
                                   id="password" 
                                   required 
                                   minlength="8"
                                   placeholder="Enter new password"
                                   class="block w-full pl-10 pr-12 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition @error('password') border-red-500 @enderror">
                            <button type="button" 
                                    onclick="togglePassword('password')"
                                    class="absolute inset-y-0 right-0 pr-3 flex items-center text-gray-400 hover:text-gray-600 focus:outline-none transition">
                                <svg id="password-eye" class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                </svg>
                                <svg id="password-eye-off" class="h-5 w-5 hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"/>
                                </svg>
                            </button>
                        </div>
                        @error('password')
                            <p class="mt-2 text-sm text-red-600 flex items-center">
                                <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                                </svg>
                                {{ $message }}
                            </p>
                        @enderror
                    </div>

                    <!-- Confirm Password Field -->
                    <div>
                        <label for="password_confirmation" class="block text-sm font-semibold text-gray-700 mb-2">
                            Confirm New Password
                        </label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                                </svg>
                            </div>
                            <input type="password" 
                                   name="password_confirmation" 
                                   id="password_confirmation" 
                                   required 
                                   minlength="8"
                                   placeholder="Confirm new password"
                                   class="block w-full pl-10 pr-12 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition">
                            <button type="button" 
                                    onclick="togglePassword('password_confirmation')"
                                    class="absolute inset-y-0 right-0 pr-3 flex items-center text-gray-400 hover:text-gray-600 focus:outline-none transition">
                                <svg id="password_confirmation-eye" class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                </svg>
                                <svg id="password_confirmation-eye-off" class="h-5 w-5 hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"/>
                                </svg>
                            </button>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <button type="submit" 
                            class="w-full bg-primary text-white px-6 py-3 rounded-lg font-bold text-lg hover:bg-primary-dark transition shadow-lg hover:shadow-xl transform hover:-translate-y-0.5">
                        Reset Password
                    </button>
                </form>

                <!-- Resend OTP -->
                <div class="mt-8">
                    <form method="POST" action="{{ route('password.resend') }}">
                        @csrf
                        <div class="text-center">
                            <p class="text-sm text-gray-600 mb-2">Didn't receive the code?</p>
                            <button type="submit" 
                                    class="text-primary font-semibold hover:text-primary-dark transition inline-flex items-center">
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                                </svg>
                                Resend Code
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Back to Login Link -->
                <div class="mt-8 text-center">
                    <a href="{{ route('login') }}" 
                       class="text-sm text-gray-600 hover:text-primary transition inline-flex items-center">
                        <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                        </svg>
                        Back to login
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function togglePassword(fieldId) {
    const field = document.getElementById(fieldId);
    const eyeIcon = document.getElementById(fieldId + '-eye');
    const eyeOffIcon = document.getElementById(fieldId + '-eye-off');
    
    if (field.type === 'password') {
        field.type = 'text';
        eyeIcon.classList.add('hidden');
        eyeOffIcon.classList.remove('hidden');
    } else {
        field.type = 'password';
        eyeIcon.classList.remove('hidden');
        eyeOffIcon.classList.add('hidden');
    }
}

function normalizeOtpInput(event) {
    const otpInput = document.getElementById('otp');
    if (otpInput) {
        // Remove all non-numeric characters and ensure exactly 6 digits
        let cleanedValue = otpInput.value.replace(/[^0-9]/g, '').slice(0, 6);
        
        // Pad with zeros if less than 6 digits (though this shouldn't happen with validation)
        if (cleanedValue.length < 6) {
            cleanedValue = cleanedValue.padStart(6, '0');
        }
        
        // Update the input value
        otpInput.value = cleanedValue;
        
        // Validate length
        if (cleanedValue.length !== 6) {
            event.preventDefault();
            alert('Please enter a 6-digit verification code.');
            return false;
        }
    }
    return true;
}
</script>
@endsection

