@extends('layouts.app')

@section('title', 'User Details')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-8 flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-gray-900">User Details</h1>
            <p class="text-gray-600 mt-2">{{ $user->name }}</p>
        </div>
        <div class="flex items-center gap-4">
            <a href="{{ route('admin.users.index') }}" class="text-primary hover:text-primary-dark">
                ← Back to Users
            </a>
            @if($user->id !== auth()->id())
                <form action="{{ route('admin.users.destroy', $user) }}" method="POST" 
                      onsubmit="return confirm('Are you sure you want to delete this user? This action cannot be undone.');">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="bg-red-600 text-white px-4 py-2 rounded-md hover:bg-red-700 transition">
                        Delete User
                    </button>
                </form>
            @endif
        </div>
    </div>

    @if(session('success'))
        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6" role="alert">
            <p>{{ session('success') }}</p>
        </div>
    @endif

    @if(session('error'))
        <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6" role="alert">
            <p>{{ session('error') }}</p>
        </div>
    @endif

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-6">
        <!-- User Information -->
        <div class="lg:col-span-2 space-y-6">
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-xl font-bold text-gray-900 mb-4">User Information</h2>
                <div class="space-y-4">
                    <div>
                        <p class="text-sm font-medium text-gray-500">Name</p>
                        <p class="text-lg font-semibold text-gray-900">{{ $user->name }}</p>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-500">Email</p>
                        <p class="text-lg font-semibold text-gray-900">{{ $user->email }}</p>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-500">Role</p>
                        <span class="inline-flex px-3 py-1 text-sm font-semibold rounded-full {{ $user->is_admin ? 'bg-purple-100 text-purple-800' : 'bg-gray-100 text-gray-800' }}">
                            {{ $user->is_admin ? 'Admin' : 'User' }}
                        </span>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-500">Member Since</p>
                        <p class="text-lg font-semibold text-gray-900">{{ $user->created_at->format('F d, Y') }}</p>
                    </div>
                </div>
            </div>

            <!-- Recent Orders -->
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-xl font-bold text-gray-900 mb-4">Recent Orders</h2>
                <div class="space-y-4">
                    @forelse($user->orders as $order)
                        <div class="border-b border-gray-200 pb-4 last:border-0 last:pb-0">
                            <div class="flex items-center justify-between">
                                <div class="flex-1">
                                    <p class="font-semibold text-gray-900">{{ $order->order_number }}</p>
                                    <p class="text-sm text-gray-600">{{ $order->created_at->format('M d, Y h:i A') }}</p>
                                </div>
                                <div class="text-right">
                                    <p class="font-bold text-primary">{{ currency($order->total) }}</p>
                                    <span class="inline-block px-2 py-1 text-xs rounded-full 
                                        {{ $order->status === 'completed' ? 'bg-green-100 text-green-800' : 
                                           ($order->status === 'pending' ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800') }}">
                                        {{ ucfirst($order->status) }}
                                    </span>
                                </div>
                            </div>
                        </div>
                    @empty
                        <p class="text-gray-500 text-center py-4">No orders yet</p>
                    @endforelse
                </div>
            </div>
        </div>

        <!-- Statistics -->
        <div class="space-y-6">
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-xl font-bold text-gray-900 mb-4">Statistics</h2>
                <div class="space-y-4">
                    <div>
                        <p class="text-sm font-medium text-gray-500">Total Orders</p>
                        <p class="text-2xl font-bold text-gray-900">{{ $totalOrders }}</p>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-500">Total Spent</p>
                        <p class="text-2xl font-bold text-primary">{{ currency($totalSpent) }}</p>
                    </div>
                </div>
            </div>

            @if($user->id !== auth()->id())
                <div class="bg-white shadow rounded-lg p-6">
                    <h2 class="text-xl font-bold text-gray-900 mb-4">Admin Actions</h2>
                    <form action="{{ route('admin.users.toggleAdmin', $user) }}" method="POST" class="mb-6">
                        @csrf
                        <button type="submit" class="w-full bg-primary text-white px-4 py-2 rounded-lg hover:bg-primary-dark transition">
                            {{ $user->is_admin ? 'Remove Admin Access' : 'Grant Admin Access' }}
                        </button>
                    </form>
                    
                    @if($user->is_admin)
                        <form action="{{ route('admin.users.updatePermissions', $user) }}" method="POST">
                            @csrf
                            @method('PUT')
                            <h3 class="text-lg font-semibold text-gray-900 mb-4">Admin Permissions</h3>
                            <div class="space-y-3">
                                <label class="flex items-center">
                                    <input type="checkbox" name="can_manage_products" value="1" {{ $user->can_manage_products ? 'checked' : '' }} class="rounded border-gray-300 text-primary focus:ring-primary">
                                    <span class="ml-2 text-sm text-gray-700">Manage Products</span>
                                </label>
                                <label class="flex items-center">
                                    <input type="checkbox" name="can_manage_orders" value="1" {{ $user->can_manage_orders ? 'checked' : '' }} class="rounded border-gray-300 text-primary focus:ring-primary">
                                    <span class="ml-2 text-sm text-gray-700">Manage Orders</span>
                                </label>
                                <label class="flex items-center">
                                    <input type="checkbox" name="can_manage_users" value="1" {{ $user->can_manage_users ? 'checked' : '' }} class="rounded border-gray-300 text-primary focus:ring-primary">
                                    <span class="ml-2 text-sm text-gray-700">Manage Users</span>
                                </label>
                                <label class="flex items-center">
                                    <input type="checkbox" name="can_manage_categories" value="1" {{ $user->can_manage_categories ? 'checked' : '' }} class="rounded border-gray-300 text-primary focus:ring-primary">
                                    <span class="ml-2 text-sm text-gray-700">Manage Categories</span>
                                </label>
                                <label class="flex items-center">
                                    <input type="checkbox" name="can_manage_sliders" value="1" {{ $user->can_manage_sliders ? 'checked' : '' }} class="rounded border-gray-300 text-primary focus:ring-primary">
                                    <span class="ml-2 text-sm text-gray-700">Manage Sliders</span>
                                </label>
                                <label class="flex items-center">
                                    <input type="checkbox" name="can_view_analytics" value="1" {{ $user->can_view_analytics ? 'checked' : '' }} class="rounded border-gray-300 text-primary focus:ring-primary">
                                    <span class="ml-2 text-sm text-gray-700">View Analytics</span>
                                </label>
                                <label class="flex items-center">
                                    <input type="checkbox" name="can_manage_settings" value="1" {{ $user->can_manage_settings ? 'checked' : '' }} class="rounded border-gray-300 text-primary focus:ring-primary">
                                    <span class="ml-2 text-sm text-gray-700">Manage Settings</span>
                                </label>
                            </div>
                            <button type="submit" class="w-full mt-4 bg-primary text-white px-4 py-2 rounded-lg hover:bg-primary-dark transition">
                                Update Permissions
                            </button>
                        </form>
                    @endif
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

