@extends('layouts.admin')

@section('title', 'Stores')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">All Stores</h3>
                </div>
                <div class="card-body">
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($stores as $store)
                                <tr>
                                    <td>{{ $store->id }}</td>
                                    <td>{{ $store->business_name }}</td>
                                    <td>{{ $store->status }}</td>
                                    <td>
                                        @if ($store->status === 'pending')
                                            <form action="{{ route('admin.approve.store') }}" method="POST">
                                                @csrf
                                                <input type="hidden" name="store_id" value="{{ $store->id }}">
                                                <button type="submit" class="btn btn-success">Approve</button>
                                            </form>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
