@extends('layouts.app')

@section('title', 'Order Details')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-8 flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-gray-900">Order Details</h1>
            <p class="text-gray-600 mt-2">Order #{{ $order->order_number }}</p>
        </div>
        <div class="flex items-center gap-4">
            <a href="{{ route('admin.orders.index') }}" class="text-primary hover:text-primary-dark">
                ← Back to Orders
            </a>
            <form action="{{ route('admin.orders.destroy', $order) }}" method="POST" 
                  onsubmit="return confirm('Are you sure you want to delete this order? This action cannot be undone.');">
                @csrf
                @method('DELETE')
                <button type="submit" class="bg-red-600 text-white px-4 py-2 rounded-md hover:bg-red-700 transition">
                    Delete Order
                </button>
            </form>
        </div>
    </div>

    @if(session('success'))
        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6" role="alert">
            <p>{{ session('success') }}</p>
        </div>
    @endif

    @if(session('error'))
        <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6" role="alert">
            <p>{{ session('error') }}</p>
        </div>
    @endif

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-6">
        <!-- Order Information -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Order Items -->
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-xl font-bold text-gray-900 mb-4">Order Items</h2>
                <div class="space-y-4">
                    @foreach($order->items as $item)
                        <div class="flex gap-4 pb-4 border-b border-gray-200 last:border-0 last:pb-0">
                            <div class="w-20 h-20 bg-gray-200 rounded-lg overflow-hidden flex-shrink-0">
                                <img src="{{ productImageUrl($item->product_image) }}" 
                                     alt="{{ $item->product_name }}" 
                                     class="w-full h-full object-cover"
                                     onerror="this.src='{{ url('images/placeholder.jpg') }}'; this.onerror=null;">
                            </div>
                            <div class="flex-1">
                                <h3 class="font-semibold text-gray-900">{{ $item->product_name }}</h3>
                                <p class="text-sm text-gray-600">Qty: {{ $item->quantity }}</p>
                                @if($item->size)
                                    <p class="text-sm text-gray-600">Size: {{ $item->size }}</p>
                                @endif
                                @if($item->color)
                                    <p class="text-sm text-gray-600">Color: {{ $item->color }}</p>
                                @endif
                                <p class="text-primary font-semibold mt-1">{{ currency($item->subtotal) }}</p>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <!-- Shipping Information -->
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-xl font-bold text-gray-900 mb-4">Shipping Information</h2>
                <div class="space-y-2 text-sm">
                    <p><span class="font-semibold">Name:</span> {{ $order->shipping_name }}</p>
                    <p><span class="font-semibold">Email:</span> {{ $order->shipping_email }}</p>
                    <p><span class="font-semibold">Phone:</span> {{ $order->shipping_phone }}</p>
                    <p><span class="font-semibold">Address:</span> {{ $order->shipping_address }}</p>
                    @if($order->notes)
                        <p class="mt-4"><span class="font-semibold">Notes:</span> {{ $order->notes }}</p>
                    @endif
                </div>
            </div>
        </div>

        <!-- Order Summary & Actions -->
        <div class="space-y-6">
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-xl font-bold text-gray-900 mb-4">Order Summary</h2>
                <div class="space-y-2 mb-4">
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Subtotal</span>
                        <span class="text-gray-900">{{ currency($order->subtotal) }}</span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Tax</span>
                        <span class="text-gray-900">{{ currency($order->tax) }}</span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Shipping</span>
                        <span class="text-gray-900">{{ currency($order->shipping) }}</span>
                    </div>
                    <div class="border-t border-gray-200 pt-2 mt-2">
                        <div class="flex justify-between">
                            <span class="font-bold text-gray-900">Total</span>
                            <span class="font-bold text-primary text-lg">{{ currency($order->total) }}</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Status Management -->
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-xl font-bold text-gray-900 mb-4">Update Status</h2>
                
                <!-- Order Status -->
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Order Status</label>
                    <form method="POST" action="{{ route('admin.orders.updateStatus', $order) }}">
                        @csrf
                        @method('PUT')
                        <select name="status" onchange="this.form.submit()" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-primary">
                            <option value="pending" {{ $order->status === 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="processing" {{ $order->status === 'processing' ? 'selected' : '' }}>Processing</option>
                            <option value="shipped" {{ $order->status === 'shipped' ? 'selected' : '' }}>Shipped</option>
                            <option value="completed" {{ $order->status === 'completed' ? 'selected' : '' }}>Completed</option>
                            <option value="cancelled" {{ $order->status === 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                        </select>
                    </form>
                </div>

                <!-- Payment Status -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Payment Status</label>
                    <form method="POST" action="{{ route('admin.orders.updatePaymentStatus', $order) }}">
                        @csrf
                        @method('PUT')
                        <select name="payment_status" onchange="this.form.submit()" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-primary">
                            <option value="pending" {{ $order->payment_status === 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="paid" {{ $order->payment_status === 'paid' ? 'selected' : '' }}>Paid</option>
                            <option value="refunded" {{ $order->payment_status === 'refunded' ? 'selected' : '' }}>Refunded</option>
                        </select>
                    </form>
                </div>
            </div>

            <!-- Order Info -->
            <div class="bg-white shadow rounded-lg p-6">
                <h2 class="text-xl font-bold text-gray-900 mb-4">Order Information</h2>
                <div class="space-y-2 text-sm">
                    <p><span class="font-semibold">Order Number:</span> {{ $order->order_number }}</p>
                    <p><span class="font-semibold">Payment Method:</span> {{ ucfirst(str_replace('_', ' ', $order->payment_method)) }}</p>
                    <p><span class="font-semibold">Placed:</span> {{ $order->created_at->format('M d, Y h:i A') }}</p>
                    @if($order->user)
                        <p><span class="font-semibold">Customer:</span> {{ $order->user->name }} ({{ $order->user->email }})</p>
                    @else
                        <p><span class="font-semibold">Customer:</span> Guest</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

