@extends('layouts.app')

@section('title', 'Email Marketing')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-gray-900">Email Marketing</h1>
        <p class="text-gray-600 mt-2">Manage newsletter subscribers and send marketing emails</p>
    </div>

    @if(session('success'))
        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6 rounded" role="alert">
            <p>{{ session('success') }}</p>
        </div>
    @endif

    @if(session('error'))
        <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6 rounded" role="alert">
            <p class="font-semibold mb-2">Error:</p>
            <p>{{ session('error') }}</p>
            <div class="mt-3 text-sm">
                <p class="font-semibold mb-1">Please ensure your .env file has the following email settings configured:</p>
                <ul class="list-disc list-inside space-y-1 text-xs">
                    <li>MAIL_MAILER=smtp</li>
                    <li>MAIL_HOST=your-smtp-host</li>
                    <li>MAIL_PORT=587 (or 465 for SSL)</li>
                    <li>MAIL_USERNAME=your-email@example.com</li>
                    <li>MAIL_PASSWORD=your-email-password</li>
                    <li>MAIL_ENCRYPTION=tls (or ssl)</li>
                    <li>MAIL_FROM_ADDRESS=your-email@example.com</li>
                    <li>MAIL_FROM_NAME="Your Site Name"</li>
                </ul>
                <p class="mt-2 text-xs">After updating .env, run: <code class="bg-red-200 px-1 rounded">php artisan config:clear</code></p>
            </div>
        </div>
    @endif

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-8">
        <!-- Statistics -->
        <div class="bg-white shadow rounded-lg p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Active Subscribers</p>
                    <p class="text-3xl font-bold text-gray-900 mt-2">{{ $totalSubscribers }}</p>
                </div>
                <div class="bg-primary/10 p-3 rounded-full">
                    <svg class="w-8 h-8 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                    </svg>
                </div>
            </div>
        </div>

        <div class="bg-white shadow rounded-lg p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Inactive Subscribers</p>
                    <p class="text-3xl font-bold text-gray-900 mt-2">{{ $totalInactive }}</p>
                </div>
                <div class="bg-gray-100 p-3 rounded-full">
                    <svg class="w-8 h-8 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"/>
                    </svg>
                </div>
            </div>
        </div>

        <div class="bg-white shadow rounded-lg p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Total Subscribers</p>
                    <p class="text-3xl font-bold text-gray-900 mt-2">{{ $totalSubscribers + $totalInactive }}</p>
                </div>
                <div class="bg-blue-100 p-3 rounded-full">
                    <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                    </svg>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Send Marketing Email Form -->
        <div class="bg-white shadow rounded-lg p-6">
            <h2 class="text-xl font-bold text-gray-900 mb-6">Send Marketing Email</h2>
            <form action="{{ route('admin.email-marketing.send') }}" method="POST">
                @csrf
                <div class="space-y-4">
                    <div>
                        <label for="subject" class="block text-sm font-semibold text-gray-700 mb-2">Subject *</label>
                        <input type="text" id="subject" name="subject" required
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition"
                               placeholder="Enter email subject">
                        @error('subject')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="message" class="block text-sm font-semibold text-gray-700 mb-2">Message *</label>
                        <textarea id="message" name="message" rows="10" required
                                  class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition resize-none"
                                  placeholder="Enter your marketing message here..."></textarea>
                        <p class="text-xs text-gray-500 mt-1">This message will be sent to all {{ $totalSubscribers }} active subscribers.</p>
                        @error('message')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <button type="submit" 
                            class="w-full bg-primary text-white px-6 py-3 rounded-lg font-bold hover:bg-primary-dark transition shadow-lg hover:shadow-xl"
                            onclick="return confirm('Are you sure you want to send this email to all {{ $totalSubscribers }} active subscribers?')">
                        Send to All Subscribers
                    </button>
                </div>
            </form>
        </div>

        <!-- Subscribers List -->
        <div class="bg-white shadow rounded-lg p-6">
            <div class="flex items-center justify-between mb-6">
                <h2 class="text-xl font-bold text-gray-900">Subscribers List</h2>
                <span class="text-sm text-gray-600">{{ $subscribers->total() }} total</span>
            </div>

            <div class="space-y-3 max-h-96 overflow-y-auto">
                @forelse($subscribers as $subscriber)
                    <div class="flex items-center justify-between p-3 border border-gray-200 rounded-lg hover:bg-gray-50 transition">
                        <div class="flex-1">
                            <p class="font-semibold text-gray-900">{{ $subscriber->email }}</p>
                            @if($subscriber->name)
                                <p class="text-sm text-gray-600">{{ $subscriber->name }}</p>
                            @endif
                            <p class="text-xs text-gray-500 mt-1">
                                Subscribed: {{ $subscriber->subscribed_at->format('M d, Y') }}
                            </p>
                        </div>
                        <div class="flex items-center gap-2">
                            <form action="{{ route('admin.email-marketing.toggle', $subscriber->id) }}" method="POST" class="inline">
                                @csrf
                                <button type="submit" 
                                        class="px-3 py-1 text-xs rounded-full {{ $subscriber->is_active ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }} hover:opacity-80 transition"
                                        title="{{ $subscriber->is_active ? 'Deactivate' : 'Activate' }}">
                                    {{ $subscriber->is_active ? 'Active' : 'Inactive' }}
                                </button>
                            </form>
                            <form action="{{ route('admin.email-marketing.destroy', $subscriber->id) }}" method="POST" class="inline" 
                                  onsubmit="return confirm('Are you sure you want to delete this subscriber?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="text-red-600 hover:text-red-800 transition" title="Delete">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                                    </svg>
                                </button>
                            </form>
                        </div>
                    </div>
                @empty
                    <p class="text-gray-500 text-center py-8">No subscribers found</p>
                @endforelse
            </div>

            <!-- Pagination -->
            @if($subscribers->hasPages())
                <div class="mt-6">
                    {{ $subscribers->links() }}
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

