<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('sliders', function (Blueprint $table) {
            $table->decimal('price', 10, 2)->nullable()->change();
            $table->string('title')->nullable()->change();
            $table->string('subtitle')->nullable()->change();
            $table->text('description')->nullable()->change();
            $table->string('image')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('sliders', function (Blueprint $table) {
            $table->decimal('price', 10, 2)->nullable(false)->change();
            $table->string('title')->nullable(false)->change();
            $table->string('subtitle')->nullable(false)->change();
            $table->text('description')->nullable(false)->change();
            $table->string('image')->nullable(false)->change();
        });
    }
};
