<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->boolean('can_manage_products')->default(false)->after('is_admin');
            $table->boolean('can_manage_orders')->default(false)->after('can_manage_products');
            $table->boolean('can_manage_users')->default(false)->after('can_manage_orders');
            $table->boolean('can_manage_categories')->default(false)->after('can_manage_users');
            $table->boolean('can_manage_sliders')->default(false)->after('can_manage_categories');
            $table->boolean('can_view_analytics')->default(false)->after('can_manage_sliders');
            $table->boolean('can_manage_settings')->default(false)->after('can_view_analytics');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'can_manage_products',
                'can_manage_orders',
                'can_manage_users',
                'can_manage_categories',
                'can_manage_sliders',
                'can_view_analytics',
                'can_manage_settings',
            ]);
        });
    }
};
