<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Drop foreign key constraint first
        DB::statement('ALTER TABLE orders DROP FOREIGN KEY orders_user_id_foreign');
        
        // Modify column to be nullable
        DB::statement('ALTER TABLE orders MODIFY COLUMN user_id BIGINT UNSIGNED NULL');
        
        // Re-add foreign key constraint
        DB::statement('ALTER TABLE orders ADD CONSTRAINT orders_user_id_foreign FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop foreign key constraint first
        DB::statement('ALTER TABLE orders DROP FOREIGN KEY orders_user_id_foreign');
        
        // Modify column to be NOT NULL
        DB::statement('ALTER TABLE orders MODIFY COLUMN user_id BIGINT UNSIGNED NOT NULL');
        
        // Re-add foreign key constraint
        DB::statement('ALTER TABLE orders ADD CONSTRAINT orders_user_id_foreign FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE');
    }
};
