<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'is_admin',
        'is_store_owner',
        'can_manage_products',
        'can_manage_orders',
        'can_manage_users',
        'can_manage_categories',
        'can_manage_sliders',
        'can_view_analytics',
        'can_manage_settings',
        'email_verification_otp',
        'email_verification_otp_expires_at',
        'password_reset_otp',
        'password_reset_otp_expires_at',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'is_admin' => 'boolean',
        'is_store_owner' => 'boolean',
        'can_manage_products' => 'boolean',
        'can_manage_orders' => 'boolean',
        'can_manage_users' => 'boolean',
        'can_manage_categories' => 'boolean',
        'can_manage_sliders' => 'boolean',
        'can_view_analytics' => 'boolean',
        'can_manage_settings' => 'boolean',
    ];

    public function cartItems()
    {
        return $this->hasMany(CartItem::class);
    }

    public function orders()
    {
        return $this->hasMany(Order::class);
    }

    public function wishlists()
    {
        return $this->hasMany(Wishlist::class);
    }

    public function addresses()
    {
        return $this->hasMany(Address::class);
    }

    public function store()
    {
        return $this->hasOne(Store::class);
    }

    public function quotes()
    {
        return $this->hasMany(Quote::class);
    }
}
