<?php

namespace App\Mail;

use App\Models\Order;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OrderConfirmationEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $order;
    public $siteTitle;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(Order $order, $siteTitle = null)
    {
        $this->order = $order;
        $this->siteTitle = $siteTitle ?? 'Vibrant Vogue';
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('Order Confirmation - ' . $this->order->order_number)
                    ->view('emails.order-confirmation')
                    ->with([
                        'order' => $this->order,
                        'siteTitle' => $this->siteTitle,
                    ]);
    }
}

