<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Mail\Mailables\Headers;
use Illuminate\Queue\SerializesModels;

class MarketingEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $subject;
    public $emailMessage;
    public $siteTitle;
    public $subscriberEmail;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($subject, $message, $siteTitle = null, $subscriberEmail = null)
    {
        $this->subject = $subject;
        $this->emailMessage = $message;
        $this->siteTitle = $siteTitle ?? 'Vibrant Vogue';
        $this->subscriberEmail = $subscriberEmail;
    }

    /**
     * Get the message envelope.
     *
     * @return \Illuminate\Mail\Mailables\Envelope
     */
    public function envelope()
    {
        $fromAddress = config('mail.from.address');
        $fromName = config('mail.from.name');
        
        return new Envelope(
            from: $fromAddress,
            subject: $this->subject,
            replyTo: $fromAddress,
            tags: ['marketing', 'newsletter'],
        );
    }

    /**
     * Get the message headers.
     *
     * @return \Illuminate\Mail\Mailables\Headers
     */
    public function headers()
    {
        $unsubscribeUrl = url('/newsletter/unsubscribe?email=' . urlencode($this->subscriberEmail ?? ''));
        
        return new Headers(
            text: [
                'List-Unsubscribe' => '<' . $unsubscribeUrl . '>',
                'List-Unsubscribe-Post' => 'List-Unsubscribe=One-Click',
                'Precedence' => 'bulk',
                'X-Mailer' => 'Laravel',
                'X-Priority' => '3',
            ],
        );
    }

    /**
     * Get the message content definition.
     *
     * @return \Illuminate\Mail\Mailables\Content
     */
    public function content()
    {
        $primaryColor = \App\Models\Setting::get('primary_color', '#ff5349');
        
        return new Content(
            view: 'emails.marketing',
            text: 'emails.marketing-text',
            with: [
                'emailMessage' => $this->emailMessage,
                'siteTitle' => $this->siteTitle,
                'primaryColor' => $primaryColor,
                'subscriberEmail' => $this->subscriberEmail,
            ],
        );
    }
}

