<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class StoreMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (!Auth::check()) {
            return redirect()->route('login')->with('error', 'Please login to access your store dashboard.');
        }

        $user = Auth::user();
        
        if (!$user->is_store_owner) {
            return redirect()->route('store.register')
                ->with('error', 'You need to register as a store first.');
        }

        if (!$user->store) {
            return redirect()->route('store.register')
                ->with('error', 'Please complete your store registration.');
        }

        if (!$user->store->isApproved()) {
            return redirect()->route('store.register')
                ->with('info', 'Your store account is pending approval. You will be notified once approved.');
        }

        return $next($request);
    }
}

