<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class RestrictToLocalhost
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // Get the client IP address
        $ip = $request->ip();
        
        // Get the host header
        $host = $request->getHost();
        
        // Get server address
        $serverAddr = $request->server('SERVER_ADDR');
        
        // Check if request is from localhost
        // Allow: 127.0.0.1, ::1 (IPv6 localhost), localhost hostname, or server running on localhost
        $isLocalhost = in_array($ip, ['127.0.0.1', '::1']) || 
                       in_array($host, ['localhost', '127.0.0.1']) ||
                       str_contains($host, 'localhost') ||
                       str_contains($host, '127.0.0.1') ||
                       in_array($serverAddr, ['127.0.0.1', '::1']) ||
                       $serverAddr === null; // If SERVER_ADDR is null, likely localhost
        
        // If not localhost, deny access
        if (!$isLocalhost) {
            abort(403, 'Access denied. This website is only accessible from localhost.');
        }
        
        return $next($request);
    }
}
