<?php

namespace App\Http\Controllers\Store;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class WithdrawController extends Controller
{
    public function index()
    {
        $store = Auth::user()->store;
        $withdrawals = $store->withdrawals()->latest()->paginate(20);
        return view('store.withdraw.index', compact('store', 'withdrawals'));
    }

    public function request(Request $request)
    {
        $request->validate([
            'amount' => 'required|numeric|min:1',
        ]);

        $store = Auth::user()->store;

        if ($request->amount > ($store->pending_earnings ?? 0)) {
            return back()->with('error', 'Insufficient balance.');
        }

        $store->withdrawals()->create([
            'amount' => $request->amount,
            'status' => 'pending',
        ]);

        $store->pending_earnings = ($store->pending_earnings ?? 0) - $request->amount;
        $store->save();

        return back()->with('success', 'Withdrawal request submitted successfully.');
    }
}
