<?php

namespace App\Http\Controllers\Store;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Order;
use App\Models\OrderItem;

class OrderController extends Controller
{
    public function index()
    {
        $store = Auth::user()->store;
        
        if (!$store) {
            return redirect()->route('store.register')
                ->with('error', 'Please complete your store registration.');
        }

        // Get orders that contain products from this store
        $storeProductIds = $store->products()->pluck('id');
        $orderIds = OrderItem::whereIn('product_id', $storeProductIds)
            ->distinct()
            ->pluck('order_id');
        
        $orders = Order::whereIn('id', $orderIds)
            ->with(['user', 'items.product'])
            ->latest()
            ->paginate(20);

        return view('store.orders.index', compact('orders', 'store'));
    }
}
