<?php

namespace App\Http\Controllers\Store;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CouponController extends Controller
{
    public function index()
    {
        $store = Auth::user()->store;
        $coupons = $store->coupons()->latest()->paginate(20);
        return view('store.coupons.index', compact('coupons'));
    }

    public function create()
    {
        return view('store.coupons.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'code' => 'required|unique:coupons,code,NULL,id,store_id,' . Auth::user()->store->id,
            'type' => 'required|in:percentage,fixed',
            'discount' => 'required|numeric|min:0',
            'expires_at' => 'nullable|date',
        ]);

        $store = Auth::user()->store;
        $store->coupons()->create($request->all());

        return redirect()->route('store.coupons.index')->with('success', 'Coupon created successfully.');
    }

    public function edit(Coupon $coupon)
    {
        return view('store.coupons.edit', compact('coupon'));
    }

    public function update(Request $request, Coupon $coupon)
    {
        $request->validate([
            'code' => 'required|unique:coupons,code,' . $coupon->id . ',id,store_id,' . Auth::user()->store->id,
            'type' => 'required|in:percentage,fixed',
            'discount' => 'required|numeric|min:0',
            'expires_at' => 'nullable|date',
        ]);

        $coupon->update($request->all());

        return redirect()->route('store.coupons.index')->with('success', 'Coupon updated successfully.');
    }

    public function destroy(Coupon $coupon)
    {
        $coupon->delete();

        return redirect()->route('store.coupons.index')->with('success', 'Coupon deleted successfully.');
    }
}
