<?php

namespace App\Http\Controllers\Store;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AnalyticsController extends Controller
{
    public function index()
    {
        $store = Auth::user()->store;
        $analytics = [
            'sales' => $store->orders()->where('status', 'completed')->sum('total'),
            'orders' => $store->orders()->count(),
            'products' => $store->products()->count(),
            'customers' => $store->orders()->distinct('user_id')->count('user_id'),
        ];
        return view('store.analytics.index', compact('store', 'analytics'));
    }
}
