<?php

namespace App\Http\Controllers;

use App\Models\NewsletterSubscriber;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class NewsletterController extends Controller
{
    public function subscribe(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email|max:255',
            'name' => 'nullable|string|max:255',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->errors()->first('email') ?? 'Please enter a valid email address.',
                ], 422);
            }
            return back()->withErrors($validator)->withInput();
        }

        $email = $request->email;
        $name = $request->name;

        // Check if email already exists
        $existing = NewsletterSubscriber::where('email', $email)->first();

        if ($existing) {
            if ($existing->is_active) {
                if ($request->ajax()) {
                    return response()->json([
                        'success' => false,
                        'message' => 'This email is already subscribed to our newsletter.',
                    ], 422);
                }
                return back()->with('error', 'This email is already subscribed to our newsletter.');
            } else {
                // Reactivate subscription
                $existing->update([
                    'is_active' => true,
                    'name' => $name ?? $existing->name,
                    'subscribed_at' => now(),
                ]);
                
                if ($request->ajax()) {
                    return response()->json([
                        'success' => true,
                        'message' => 'Thank you for resubscribing to our newsletter!',
                    ]);
                }
                return back()->with('success', 'Thank you for resubscribing to our newsletter!');
            }
        }

        // Create new subscription
        NewsletterSubscriber::create([
            'email' => $email,
            'name' => $name,
            'is_active' => true,
            'subscribed_at' => now(),
        ]);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Thank you for subscribing to our newsletter!',
            ]);
        }

        return back()->with('success', 'Thank you for subscribing to our newsletter!');
    }
}
