<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Store;
use Illuminate\Http\Request;

class StoreController extends Controller
{
    public function index(Request $request)
    {
        $query = Store::with('user');

        // Filter by status
        if ($request->has('status') && $request->status !== '') {
            $query->where('status', $request->status);
        } else {
            // Default to showing pending stores
            $query->where('status', 'pending');
        }

        // Search by business name, owner name, or email
        if ($request->has('search') && $request->search !== '') {
            $search = $request->search;
            $query->where(function($q) use ($search) {
                $q->where('business_name', 'like', "%{$search}%")
                  ->orWhere('slug', 'like', "%{$search}%")
                  ->orWhereHas('user', function($userQuery) use ($search) {
                      $userQuery->where('name', 'like', "%{$search}%")
                                ->orWhere('email', 'like', "%{$search}%");
                  });
            });
        }

        $stores = $query->latest()->paginate(20);
        
        // Get counts for filters
        $pendingCount = Store::where('status', 'pending')->count();
        $approvedCount = Store::where('status', 'approved')->count();
        $suspendedCount = Store::where('status', 'suspended')->count();
        $rejectedCount = Store::where('status', 'rejected')->count();
        $totalCount = Store::count();

        return view('admin.stores.index', compact('stores', 'pendingCount', 'approvedCount', 'suspendedCount', 'rejectedCount', 'totalCount'));
    }
}