<?php

if (!function_exists('currency')) {
    /**
     * Format price with current currency
     */
    function currency($amount, $currency = null)
    {
        $currencyService = app(\App\Services\CurrencyService::class);
        
        if ($currency === null) {
            $currency = $currencyService->getCurrentCurrency();
        }
        
        return $currencyService->format($amount, $currency);
    }
}

if (!function_exists('getCurrentCurrency')) {
    /**
     * Get current currency
     */
    function getCurrentCurrency()
    {
        $currencyService = app(\App\Services\CurrencyService::class);
        return $currencyService->getCurrentCurrency();
    }
}

