# Fashion Shopping Website

A beautiful and elegant fashion shopping website built with Laravel 9. This website features a modern UI/UX design with a complete e-commerce functionality.

## Features

- 🛍️ **Product Catalog**: Browse products with categories, filters, and search
- 🛒 **Shopping Cart**: Add products to cart with size and color options
- 📦 **Order Management**: Complete order placement and tracking system
- 👤 **User Authentication**: Login and registration system
- 🎨 **Beautiful UI**: Modern, responsive design with Tailwind CSS
- 🔍 **Search & Filters**: Search products and filter by category, price range
- ⭐ **Featured Products**: Highlight special products on homepage

## Requirements

- PHP >= 8.0
- Composer
- MySQL/MariaDB
- Node.js & NPM (for assets)

## Installation

1. **Clone the repository**
   ```bash
   git clone <repository-url>
   cd VV
   ```

2. **Install dependencies**
   ```bash
   composer install
   ```

3. **Configure environment**
   ```bash
   cp .env.example .env
   php artisan key:generate
   ```

4. **Update .env file**
   - Set your database credentials:
     ```
     DB_CONNECTION=mysql
     DB_HOST=127.0.0.1
     DB_PORT=3306
     DB_DATABASE=your_database_name
     DB_USERNAME=your_username
     DB_PASSWORD=your_password
     ```

5. **Run migrations**
   ```bash
   php artisan migrate
   ```

6. **Seed database (optional)**
   ```bash
   php artisan db:seed
   ```

7. **Create storage link**
   ```bash
   php artisan storage:link
   ```

8. **Configure for WAMP/Apache**
   
   Since you're using WAMP, you don't need to run Laravel's built-in server. Instead:
   
   - Make sure WAMP is running (Apache and MySQL services should be active)
   - Your project is already in `C:\wamp64\www\VV`
   - Update your `.env` file to set the correct APP_URL:
     ```
     APP_URL=http://localhost/VV
     ```
   
   **Important:** If `http://localhost/VV` gives 404 but `http://localhost/VV/public` works:
   
   **Option A: Check Apache AllowOverride (Recommended)**
   1. Open WAMP menu → Apache → httpd.conf
   2. Find the section for `<Directory "C:/wamp64/www">`
   3. Make sure it has: `AllowOverride All`
   4. Restart Apache
   5. Try `http://localhost/VV` again
   
   **Option B: Use Virtual Host (Best Solution)**
   1. Open WAMP menu → Apache → httpd-vhosts.conf
   2. Add this configuration:
   ```apache
   <VirtualHost *:80>
       DocumentRoot "C:/wamp64/www/VV/public"
       ServerName localhost
       <Directory "C:/wamp64/www/VV/public">
           Options Indexes FollowSymLinks
           AllowOverride All
           Require all granted
       </Directory>
   </VirtualHost>
   ```
   3. Restart Apache
   4. Access via: `http://localhost/VV` (should work now)
   
   **Option C: Use Laravel's built-in server**
   ```bash
   php artisan serve --host=127.0.0.1 --port=8000
   ```
   Then access via: `http://localhost:8000`

9. **Visit the website**
   - **For WAMP/Apache:** Open your browser and go to: `http://localhost/VV`
   - **For Laravel server:** Open your browser and go to: `http://localhost:8000`
   - The website is only accessible from your local machine (localhost).

## Database Structure

- **users**: User accounts
- **categories**: Product categories
- **products**: Product catalog
- **cart_items**: Shopping cart items
- **orders**: Customer orders
- **order_items**: Order line items

## Default Routes

- `/` - Homepage
- `/products` - Product listing
- `/products/{slug}` - Product details
- `/cart` - Shopping cart (requires authentication)
- `/checkout` - Checkout page (requires authentication)
- `/orders` - Order history (requires authentication)
- `/login` - Login page
- `/register` - Registration page

## Features Overview

### Homepage
- Hero section with call-to-action
- Featured products showcase
- Latest arrivals section
- Category browsing

### Product Listing
- Advanced filtering (category, price range)
- Search functionality
- Sorting options (price, name, latest)
- Pagination

### Product Details
- High-quality product images
- Detailed product information
- Size and color selection
- Add to cart functionality
- Related products

### Shopping Cart
- View cart items
- Update quantities
- Remove items
- Order summary with tax and shipping

### Checkout
- Shipping information form
- Payment method selection
- Order summary
- Order placement

### Order Management
- View order history
- Order details
- Order status tracking

## Customization

### Adding Products
You can add products through the database seeder or create an admin panel. The seeder includes sample products for testing.

### Styling
The website uses Tailwind CSS via CDN. You can customize colors and styles in the blade templates.

### Images
Product images should be stored in `storage/app/public/products/` directory. The storage link connects this to `public/storage/`.

## Security Notes

- **Localhost Only Access:** The server should always be started with `--host=127.0.0.1` to bind only to localhost. This prevents public access from external networks.
- By binding to `127.0.0.1` instead of `0.0.0.0`, the server will only accept connections from your local machine.
- This is the recommended way to run a development server to prevent accidental public exposure.

## Other Notes

- Make sure to create the `storage/app/public/products/` directory for product images
- The website uses placeholder images - replace them with actual product images
- Tax is set to 10% and shipping is $15.00 - you can modify these in the OrderController

## License

This project is open-sourced software licensed under the MIT license.
