# Production Server Setup

## 1. Update .env File

Make sure your `.env` has:
```env
APP_URL=https://vibrantvogue.shop
SESSION_LIFETIME=20160
```

**IMPORTANT**: No trailing slash, no subdirectory!

## 2. Upload Updated Files

Upload these files:
- `app/Helpers/ImageHelper.php` (updated helper)

## 3. Run These Commands on Server

```bash
# 1. Regenerate autoload (CRITICAL!)
composer dump-autoload

# 2. Clear all caches
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear

# 3. Update APP_URL in .env (if needed)
# Edit .env: APP_URL=https://vibrantvogue.shop

# 4. Cache config
php artisan config:cache

# 5. Verify storage link exists
ls -la public/storage
# Should show: public/storage -> ../storage/app/public

# 6. If link doesn't exist:
php artisan storage:link
```

## 4. How It Works

- **Localhost (WAMP)**: Uses `/public/storage/` path
  - APP_URL: `http://localhost/VV`
  - Image URL: `http://localhost/VV/public/storage/products/image.jpg`

- **Production**: Uses `/storage/` path (via symlink)
  - APP_URL: `https://vibrantvogue.shop`
  - Image URL: `https://vibrantvogue.shop/storage/products/image.jpg`

The helper automatically detects localhost vs production and uses the correct path!

## 5. Test

After setup, test an image directly:
```
https://vibrantvogue.shop/storage/products/[actual-filename.jpg]
```

If that works, images should work everywhere on the site!

