# PRODUCTION IMAGE FIX - EXACT STEPS

Follow these steps **EXACTLY** in order. Don't skip any step.

## Files to Upload

Upload these 3 files to your server:
1. `app/Helpers/ImageHelper.php` (simplified version)
2. `app/Providers/AppServiceProvider.php` (already updated)
3. `public/.htaccess` (already updated)
4. `DIAGNOSE_PRODUCTION.php` (diagnostic script)

## Step-by-Step Commands

**SSH into your server and run these commands ONE BY ONE:**

```bash
# Step 1: Go to project directory
cd /home/vendymal/vibrantvogue.shop

# Step 2: Regenerate autoload (CRITICAL - loads helper function)
composer dump-autoload

# Step 3: Check your .env file
cat .env | grep -E "APP_URL|APP_ENV"
# Should show:
# APP_ENV=production
# APP_URL=https://vibrantvogue.shop
# 
# If APP_ENV is not "production", edit .env:
nano .env
# Change: APP_ENV=production
# Change: APP_URL=https://vibrantvogue.shop
# (NO trailing slash!)
# Save: Ctrl+X, then Y, then Enter

# Step 4: Clear ALL caches
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear

# Step 5: Cache config again (uses .env values)
php artisan config:cache

# Step 6: Verify config is correct
php artisan tinker --execute="echo 'APP_ENV: ' . config('app.env') . PHP_EOL; echo 'APP_URL: ' . config('app.url') . PHP_EOL;"
# Should show:
# APP_ENV: production
# APP_URL: https://vibrantvogue.shop

# Step 7: Check storage symlink
ls -la public/storage
# Should show: lrwxrwxrwx ... public/storage -> ../storage/app/public
# 
# If it shows a directory (drwx...) instead of a link (lrwx...), DELETE IT and recreate:
rm -rf public/storage
php artisan storage:link
ls -la public/storage
# Should now show the symlink

# Step 8: Verify files exist
ls -la storage/app/public/products/ | head -3
# Should show your image files

# Step 9: Test helper function
php artisan tinker --execute="
if (function_exists('productImageUrl')) {
    echo 'Helper exists: YES' . PHP_EOL;
    \$p = \App\Models\Product::whereNotNull('image')->first();
    if (\$p) {
        echo 'Product: ' . \$p->name . PHP_EOL;
        echo 'DB Path: ' . \$p->image . PHP_EOL;
        echo 'Generated URL: ' . productImageUrl(\$p->image) . PHP_EOL;
    }
} else {
    echo 'Helper exists: NO - Run: composer dump-autoload' . PHP_EOL;
}
"

# Step 10: Check .htaccess
cat public/.htaccess | grep -A 1 "storage"
# Should show:
# RewriteCond %{REQUEST_URI} ^/storage/
# RewriteRule ^ - [L]
# 
# If not, the .htaccess file wasn't uploaded correctly

# Step 11: Test direct image access
# Get a real image filename:
IMAGE_FILE=$(ls storage/app/public/products/ | head -1)
echo "Test this URL in your browser:"
echo "https://vibrantvogue.shop/storage/products/$IMAGE_FILE"
# If this returns 404, the .htaccess rule isn't working
```

## Run Diagnostic Script

After running all commands, visit in your browser:
```
https://vibrantvogue.shop/DIAGNOSE_PRODUCTION.php
```

This will show you exactly what's wrong.

## Common Problems & Solutions

### Problem 1: "Call to undefined function productImageUrl()"
**Solution:**
```bash
composer dump-autoload
php artisan config:clear
php artisan config:cache
```

### Problem 2: Symlink is a directory, not a link
**Solution:**
```bash
rm -rf public/storage
php artisan storage:link
```

### Problem 3: Direct image URL returns 404
**Solution:** Check `.htaccess` has the storage exclusion rule. If not, upload the correct `.htaccess` file.

### Problem 4: URLs still use localhost
**Solution:**
```bash
# Make sure .env has:
APP_ENV=production
APP_URL=https://vibrantvogue.shop

# Then:
php artisan config:clear
php artisan config:cache
```

### Problem 5: URLs use /public/storage/ instead of /storage/
**Solution:** This means `APP_ENV` is not set to `production`. Fix `.env` and run:
```bash
php artisan config:clear
php artisan config:cache
```

## Final Verification

1. Visit: `https://vibrantvogue.shop/DIAGNOSE_PRODUCTION.php`
2. All checks should show green ✓
3. Visit a product page - images should load
4. Visit homepage - images should load

## Still Not Working?

Share the output of:
```bash
php artisan tinker --execute="
echo 'APP_ENV: ' . config('app.env') . PHP_EOL;
echo 'APP_URL: ' . config('app.url') . PHP_EOL;
echo 'Helper exists: ' . (function_exists('productImageUrl') ? 'YES' : 'NO') . PHP_EOL;
\$p = \App\Models\Product::whereNotNull('image')->first();
if (\$p) {
    echo 'Sample URL: ' . productImageUrl(\$p->image) . PHP_EOL;
}
"
```

And the output from: `https://vibrantvogue.shop/DIAGNOSE_PRODUCTION.php`

