# Production Deployment Guide

## Files to Upload

Upload these updated files to your production server:

1. **`app/Helpers/ImageHelper.php`** - Updated to work with both local IP access and production
2. **`app/Providers/AppServiceProvider.php`** - Only forces URL in production
3. **`public/.htaccess`** - Excludes `/storage/` from rewrite rules

## Server Setup Commands

Run these commands on your production server **in order**:

```bash
# 1. Regenerate autoload (CRITICAL - loads the updated helper)
composer dump-autoload

# 2. Clear all caches
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear

# 3. Verify .env has correct APP_URL
# Edit .env and ensure:
# APP_ENV=production
# APP_URL=https://vibrantvogue.shop
# (No trailing slash!)

# 4. Cache config (uses APP_URL from .env)
php artisan config:cache

# 5. Verify storage symlink exists
ls -la public/storage
# Should show: public/storage -> ../storage/app/public

# 6. If symlink doesn't exist, create it:
php artisan storage:link

# 7. Verify storage directories exist
ls -la storage/app/public/products/
# Should show your product images

# 8. Test an image URL directly:
# https://vibrantvogue.shop/storage/products/[actual-filename.jpg]
```

## How It Works

### Local Development
- **Environment**: `APP_ENV=local`
- **URL Detection**: Uses actual request URL (supports IP access like `192.168.1.100`)
- **Storage Path**: `/public/storage/` (WAMP subdirectory)
- **Example**: `http://192.168.1.100/VV/public/storage/products/image.jpg`

### Production
- **Environment**: `APP_ENV=production`
- **URL Detection**: Uses `APP_URL` from `.env` (forced by `AppServiceProvider`)
- **Storage Path**: `/storage/` (via symlink)
- **Example**: `https://vibrantvogue.shop/storage/products/image.jpg`

## Troubleshooting

### Images Still Not Loading?

1. **Check .htaccess is uploaded**:
   ```bash
   cat public/.htaccess | grep storage
   # Should show: RewriteCond %{REQUEST_URI} ^/storage/
   ```

2. **Verify symlink**:
   ```bash
   ls -la public/storage
   # Should be a symlink, not a directory
   ```

3. **Check file permissions**:
   ```bash
   ls -la storage/app/public/products/ | head -3
   # Files should be readable
   ```

4. **Test direct access**:
   ```
   https://vibrantvogue.shop/storage/products/[actual-filename.jpg]
   ```
   If this returns 404, the `.htaccess` rule isn't working.

5. **Check Apache FollowSymLinks**:
   - The `.htaccess` has `Options +FollowSymLinks`
   - If still not working, check Apache main config allows `FollowSymLinks`

6. **Verify APP_URL**:
   ```bash
   php artisan tinker --execute="echo config('app.url');"
   # Should show: https://vibrantvogue.shop
   ```

## Quick Test

After deployment, test this in browser:
```
https://vibrantvogue.shop/storage/products/[any-product-image.jpg]
```

If the image loads, everything is working! ✅

