# Fix Storage Link Issues

## Problem: `php artisan storage:link` not working or images not loading

## Solution 1: Manual Symlink Creation

If `php artisan storage:link` doesn't work, create the symlink manually:

```bash
# Navigate to your project root
cd /home/vendymal/vibrantvogue.shop

# Remove existing link if it exists (if broken)
rm -rf public/storage

# Create symlink manually
ln -s ../storage/app/public public/storage

# Verify the link
ls -la public/storage
```

## Solution 2: Check and Fix Permissions

```bash
# Make sure storage directory exists and has correct permissions
mkdir -p storage/app/public/products
chmod -R 775 storage
chmod -R 775 public

# If using www-data user:
chown -R www-data:www-data storage public/storage

# Or if using your user:
chown -R vendymal:vendymal storage public/storage
```

## Solution 3: Alternative - Copy Files Instead of Symlink

If symlinks don't work on your server, you can copy files:

```bash
# Copy storage contents to public (not recommended for production, but works)
cp -r storage/app/public/* public/storage/
```

## Solution 4: Check Web Server Configuration

### For Apache (.htaccess should allow symlinks):
Make sure your `.htaccess` in public directory has:
```apache
Options +FollowSymLinks
```

### For Nginx:
Make sure symlinks are enabled in nginx config.

## Solution 5: Verify the Link

```bash
# Check if link exists and points to correct location
ls -la public/storage

# Should show something like:
# lrwxrwxrwx 1 vendymal vendymal 25 Nov 11 19:00 public/storage -> ../storage/app/public
```

## Solution 6: Test Direct Access

Try accessing an image directly:
```
https://vibrantvogue.shop/storage/products/[image-filename]
```

If this works, the symlink is fine and the issue is in the code.
If this doesn't work, the symlink or permissions are the problem.

## Quick Diagnostic Commands

```bash
# 1. Check if storage directory exists
ls -la storage/app/public/products/

# 2. Check if symlink exists
ls -la public/storage

# 3. Check permissions
ls -ld storage
ls -ld public/storage

# 4. Test if you can create files in storage
touch storage/app/public/test.txt
rm storage/app/public/test.txt
```

