# FIX PRODUCTION IMAGES - Step by Step

## Step 1: Upload Diagnostic Script

Upload `DIAGNOSE_PRODUCTION.php` to your server root, then visit:
```
https://vibrantvogue.shop/DIAGNOSE_PRODUCTION.php
```

This will show you exactly what's wrong.

## Step 2: Run These Commands (IN ORDER)

```bash
# 1. Make sure you're in the project root
cd /home/vendymal/vibrantvogue.shop

# 2. Regenerate autoload (CRITICAL - loads the helper function)
composer dump-autoload

# 3. Clear ALL caches
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear

# 4. Check your .env file
cat .env | grep APP_URL
# Should show: APP_URL=https://vibrantvogue.shop
# If not, edit .env and set it

# 5. Check APP_ENV
cat .env | grep APP_ENV
# Should show: APP_ENV=production
# If not, edit .env and set it

# 6. Cache config again (uses .env values)
php artisan config:cache

# 7. Check if symlink exists
ls -la public/storage
# Should show: public/storage -> ../storage/app/public
# If it shows a directory or doesn't exist, run:
rm -rf public/storage
php artisan storage:link

# 8. Verify files exist
ls -la storage/app/public/products/ | head -5
# Should show your image files

# 9. Test helper function
php artisan tinker --execute="
\$p = \App\Models\Product::whereNotNull('image')->first();
if (\$p) {
    echo 'Product: ' . \$p->name . PHP_EOL;
    echo 'DB Path: ' . \$p->image . PHP_EOL;
    echo 'Generated URL: ' . productImageUrl(\$p->image) . PHP_EOL;
} else {
    echo 'No products found' . PHP_EOL;
}
"

# 10. Check .htaccess
cat public/.htaccess | grep -A 2 storage
# Should show the storage exclusion rule
```

## Step 3: Common Issues & Fixes

### Issue 1: Helper function not found
**Symptom**: "Call to undefined function productImageUrl()"
**Fix**:
```bash
composer dump-autoload
```

### Issue 2: Symlink is a directory, not a link
**Symptom**: `public/storage` is a directory
**Fix**:
```bash
rm -rf public/storage
php artisan storage:link
```

### Issue 3: Images return 404
**Symptom**: Direct URL like `https://vibrantvogue.shop/storage/products/image.jpg` returns 404
**Fix**: Check `.htaccess` has this rule:
```apache
# Don't rewrite storage requests
RewriteCond %{REQUEST_URI} ^/storage/
RewriteRule ^ - [L]
```

### Issue 4: URLs use /public/storage/ instead of /storage/
**Symptom**: Generated URLs have `/public/storage/` in them
**Fix**: 
1. Make sure `APP_ENV=production` in `.env`
2. Run `php artisan config:cache`
3. The helper should detect production and use `/storage/`

### Issue 5: APP_URL is wrong
**Symptom**: URLs point to localhost or wrong domain
**Fix**:
1. Edit `.env`: `APP_URL=https://vibrantvogue.shop` (no trailing slash!)
2. Run `php artisan config:clear && php artisan config:cache`

## Step 4: Verify It Works

After running all commands, test:

1. **Direct image access**:
   ```
   https://vibrantvogue.shop/storage/products/[any-image.jpg]
   ```
   Should show the image, not 404.

2. **Check a product page**:
   Visit any product page - images should load.

3. **Check homepage**:
   Visit homepage - slider and product images should load.

## Still Not Working?

Run the diagnostic script and share the output:
```
https://vibrantvogue.shop/DIAGNOSE_PRODUCTION.php
```

This will show exactly what's wrong.

