# Fix 404 Error - Step by Step

## Run These Commands on Server:

```bash
# 1. Verify file exists
ls -la storage/app/public/products/2DcmpTwuOJmxAyp09jmG91Xc9PqwoHi7I3es5DJv.jpg

# 2. Verify symlink works
ls -la public/storage/products/2DcmpTwuOJmxAyp09jmG91Xc9PqwoHi7I3es5DJv.jpg

# 3. Test if you can read through symlink
file public/storage/products/2DcmpTwuOJmxAyp09jmG91Xc9PqwoHi7I3es5DJv.jpg

# 4. Fix permissions
chmod -R 755 public/storage
chmod -R 755 storage/app/public

# 5. Recreate symlink (just to be sure)
rm -rf public/storage
php artisan storage:link

# 6. Verify symlink
ls -la public/storage
# Should show: public/storage -> ../storage/app/public

# 7. Upload updated .htaccess file
# (I've added FollowSymLinks to public/.htaccess)
```

## Files to Upload:

1. `app/Helpers/ImageHelper.php` ✅ (Already uploaded)
2. `public/.htaccess` ✅ (Updated to allow symlinks)

## After Uploading:

```bash
# Clear caches
php artisan config:clear
php artisan cache:clear
php artisan view:clear
```

## Test:

Try accessing directly:
```
https://vibrantvogue.shop/storage/products/2DcmpTwuOJmxAyp09jmG91Xc9PqwoHi7I3es5DJv.jpg
```

If still 404, run the diagnostic commands above and share the output.

