# Fix 404 Error for Images

## The Problem
URLs are generated correctly: `https://vibrantvogue.shop/storage/products/image.jpg`
But returns 404 - means web server can't access the symlink.

## Solution 1: Check if file exists

```bash
# Check if file exists in storage
ls -la storage/app/public/products/2DcmpTwuOJmxAyp09jmG91Xc9PqwoHi7I3es5DJv.jpg

# Check if symlink works
ls -la public/storage/products/2DcmpTwuOJmxAyp09jmG91Xc9PqwoHi7I3es5DJv.jpg
```

## Solution 2: Fix Symlink (if broken)

```bash
# Remove broken symlink
rm -rf public/storage

# Create new symlink
php artisan storage:link

# Verify
ls -la public/storage
# Should show: public/storage -> ../storage/app/public
```

## Solution 3: Check Web Server Configuration

### For Apache (.htaccess in public folder should allow symlinks):

Check `public/.htaccess` - make sure it has:
```apache
Options +FollowSymLinks
```

### For Nginx:
Make sure symlinks are enabled in nginx config.

## Solution 4: Test Direct Access

```bash
# Test if you can read the file through symlink
cat public/storage/products/2DcmpTwuOJmxAyp09jmG91Xc9PqwoHi7I3es5DJv.jpg | head -c 100
# Should output binary data, not error
```

## Solution 5: Check Permissions

```bash
# Make sure public/storage is readable
chmod -R 755 public/storage
chmod -R 755 storage/app/public

# Check ownership
ls -la public/storage
ls -la storage/app/public/products/
```

## Solution 6: Alternative - Copy Files (Temporary Fix)

If symlinks don't work on your server:

```bash
# Copy files from storage to public (not ideal, but works)
cp -r storage/app/public/* public/storage/
```

But this means you need to copy files every time you upload new images.

## Most Likely Issue

The symlink exists but web server (Apache/Nginx) doesn't have permission to follow it, or symlinks are disabled.

Run these and share output:
```bash
ls -la public/storage/products/2DcmpTwuOJmxAyp09jmG91Xc9PqwoHi7I3es5DJv.jpg
file public/storage/products/2DcmpTwuOJmxAyp09jmG91Xc9PqwoHi7I3es5DJv.jpg
```

