#!/bin/bash
# Run this on your server to debug 404 issue

echo "=== DEBUGGING 404 ERROR ==="
echo ""

# 1. Check if file exists in storage
echo "1. Checking if file exists in storage:"
ls -la storage/app/public/products/2DcmpTwuOJmxAyp09jmG91Xc9PqwoHi7I3es5DJv.jpg
echo ""

# 2. Check if symlink exists
echo "2. Checking symlink:"
ls -la public/storage
echo ""

# 3. Check if file accessible through symlink
echo "3. Checking file through symlink:"
ls -la public/storage/products/2DcmpTwuOJmxAyp09jmG91Xc9PqwoHi7I3es5DJv.jpg
echo ""

# 4. Test reading file
echo "4. Testing file read:"
file public/storage/products/2DcmpTwuOJmxAyp09jmG91Xc9PqwoHi7I3es5DJv.jpg
echo ""

# 5. Check permissions
echo "5. Checking permissions:"
stat public/storage/products/2DcmpTwuOJmxAyp09jmG91Xc9PqwoHi7I3es5DJv.jpg
echo ""

# 6. Check web server user
echo "6. Web server user (if Apache):"
ps aux | grep -E 'apache|httpd' | head -1
echo ""

# 7. Test direct access path
echo "7. Testing direct path:"
test -r public/storage/products/2DcmpTwuOJmxAyp09jmG91Xc9PqwoHi7I3es5DJv.jpg && echo "File is readable" || echo "File is NOT readable"
echo ""

# 8. Check .htaccess
echo "8. Checking .htaccess:"
cat public/.htaccess | grep -i "FollowSymLinks\|Options"
echo ""

echo "=== END DEBUG ==="

