# Check Storage Link

If you get "link already exists", verify it's correct:

## On your server, run:

```bash
# Check if link exists and where it points
ls -la public/storage

# Should show something like:
# lrwxrwxrwx 1 user user 25 Nov 11 19:00 public/storage -> ../storage/app/public
```

## If the link is broken or wrong:

```bash
# Remove the broken link
rm -rf public/storage

# Create it again
php artisan storage:link
```

## Verify it works:

```bash
# Check if you can access storage directory
ls -la public/storage/products/

# Should show your product images
```

## If images still don't load:

1. Check permissions:
```bash
chmod -R 775 storage/app/public
chmod -R 775 public/storage
```

2. Make sure files exist:
```bash
ls -la storage/app/public/products/
```

3. Test direct access in browser:
```
https://vibrantvogue.shop/storage/products/[actual-filename.jpg]
```

If direct access works but images don't show in the site → It's a code/helper issue
If direct access doesn't work → It's a symlink/permissions issue

